/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.forge.mixins.dawnera;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.utils.CachedPets;
import com.shiftthedev.pickablepets.utils.PlayerPets;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;

@Mixin(value={BaseAnimal.class})
public abstract class BaseAnimalMixin
extends Animal {
    @Shadow
    public abstract UUID getOwnerUUID();

    protected BaseAnimalMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"mobInteract"}, at={@At(value="INVOKE", target="Lru/xishnikus/thedawnera/common/entity/entity/base/BaseAnimal;setTamed(Z)V", shift=At.Shift.AFTER)})
    private void tame(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        String entityKey;
        if (!(this.m_9236_().f_46443_ || PickablePets.CONFIG.BlacklistedPets.contains(entityKey = EntityType.m_20613_((EntityType)this.m_6095_()).toString()) || PickablePets.CONFIG.BlacklistedMods.contains(entityKey.split(":")[0]))) {
            UUID owner = this.getOwnerUUID();
            if (owner == null) {
                return;
            }
            Path path = ((ServerLevel)this.m_9236_()).m_7654_().m_129843_(new LevelResource("data/pets"));
            path = path.resolve(owner.toString() + ".pets");
            PlayerPets.addPetAsync(path, this.m_20148_());
            CachedPets.addPet((LivingEntity)((BaseAnimal)this));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void readAdditionalSaveData_pets(CompoundTag compoundTag, CallbackInfo ci) {
        String entityKey;
        if (!(this.m_9236_().f_46443_ || PickablePets.CONFIG.BlacklistedPets.contains(entityKey = EntityType.m_20613_((EntityType)this.m_6095_()).toString()) || PickablePets.CONFIG.BlacklistedMods.contains(entityKey.split(":")[0]) || CachedPets.isPetUpdated(this.m_20148_()) || !compoundTag.m_128403_("Owner"))) {
            PlayerPets.saveOldPet(this.m_20148_().toString(), compoundTag.m_128342_("Owner").toString(), (ServerLevel)this.m_9236_());
            CachedPets.addPet((LivingEntity)((BaseAnimal)this));
            CachedPets.setUpdated(this.m_20148_());
        }
    }
}

