/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.shiftthedev.pickablepets.client.gui.AltarButton;
import com.shiftthedev.pickablepets.client.gui.PetButton;
import com.shiftthedev.pickablepets.containers.ReviveAltarContainer;
import com.shiftthedev.pickablepets.network.AltarPacket;
import com.shiftthedev.pickablepets.network.RevivePacket;
import com.shiftthedev.pickablepets.utils.CachedPets;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ReviveAltarScreen
extends AbstractContainerScreen<ReviveAltarContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("pickablepets", "textures/gui/altar.png");
    private int petItem;
    private int scrollOff;
    private boolean isDragging;
    private boolean isLoading;
    private List<UUID> petIDS;
    private PetButton[] petButtons;
    private AltarButton selectButton;
    private AltarButton reviveButton;

    public ReviveAltarScreen(ReviveAltarContainer reviveAltarContainer, Inventory inventory, Component component) {
        super((AbstractContainerMenu)reviveAltarContainer, inventory, component);
        this.f_97726_ = 276;
        this.f_97730_ = 107;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.selectButton = (AltarButton)this.m_142416_((GuiEventListener)new AltarButton(193 + this.f_97735_, 51 + this.f_97736_, true, (Component)Component.m_237115_((String)"gui.pickablepets.select"), button -> {}));
        this.selectButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.pickablepets.select.tooltip")));
        this.reviveButton = (AltarButton)this.m_142416_((GuiEventListener)new AltarButton(193 + this.f_97735_, 51 + this.f_97736_, false, (Component)Component.m_237115_((String)"gui.pickablepets.revive"), button -> this.reviveButtonClick()));
        this.reviveButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.pickablepets.revive.tooltip")));
        this.isLoading = true;
        this.petItem = -1;
        AltarPacket.Client.sendToServer();
    }

    public void populatePetList(List<UUID> newPetList) {
        if (!newPetList.isEmpty()) {
            this.petIDS = newPetList;
            int i = (this.f_96543_ - this.f_97726_) / 2;
            int j = (this.f_96544_ - this.f_97727_) / 2;
            int k = j + 16;
            int limit = Math.min(newPetList.size(), 7);
            this.petButtons = new PetButton[limit];
            for (int index = 0; index < limit; ++index) {
                this.petButtons[index] = (PetButton)this.m_142416_((GuiEventListener)new PetButton(i + 5, k, index, newPetList.get(index), this::petButtonClick));
                k += 20;
            }
        }
        this.isLoading = false;
    }

    private void petButtonClick(Button button) {
        if (button instanceof PetButton) {
            PetButton petButton = (PetButton)button;
            this.petItem = petButton.getIndex() + this.scrollOff;
            if (this.petItem != -1) {
                this.selectButton.f_93623_ = false;
                this.selectButton.f_93624_ = false;
                this.reviveButton.f_93624_ = true;
                this.reviveButton.f_93623_ = !CachedPets.isPetAlive(petButton.getPetID()) && ((ReviveAltarContainer)this.f_97732_).hasReviveCurrency() && Minecraft.m_91087_().f_91074_ != null;
            }
        }
    }

    private void reviveButtonClick() {
        if (this.petItem == -1 || !((ReviveAltarContainer)this.f_97732_).hasReviveCurrency()) {
            return;
        }
        RevivePacket.Client.sendToServer(this.petIDS.get(this.petItem), ((ReviveAltarContainer)this.f_97732_).getBlockPosition());
    }

    public void updateButtons(boolean fullRefresh) {
        boolean alive;
        UUID id;
        LivingEntity pet;
        if (fullRefresh) {
            AltarPacket.Client.sendToServer();
        }
        this.reviveButton.f_93623_ = this.petItem != -1 && ((ReviveAltarContainer)this.f_97732_).hasReviveCurrency() ? ((pet = CachedPets.getPet(id = this.petIDS.get(this.petItem))) != null && Minecraft.m_91087_().f_91074_ != null ? !(alive = CachedPets.isPetAlive(id)) : false) : false;
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        LivingEntity pet;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, i, j, f);
        if (this.petIDS != null && !this.petIDS.isEmpty() && this.petButtons != null) {
            int k = (this.f_96543_ - this.f_97726_) / 2;
            int l = (this.f_96544_ - this.f_97727_) / 2;
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            this.renderScroller(guiGraphics, k, l);
            int start = this.scrollOff;
            for (PetButton button : this.petButtons) {
                button.updateButton(this.petIDS.get(start), start);
                button.f_93624_ = button.getIndex() < this.petIDS.size();
                ++start;
            }
            RenderSystem.enableDepthTest();
        }
        if (this.petItem != -1 && (pet = CachedPets.getRender(this.petIDS.get(this.petItem))) != null) {
            InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)(this.f_97735_ + 137), (int)(this.f_97736_ + 60), (int)30, (float)((float)(this.f_97735_ + 112) - (float)i), (float)((float)(this.f_97736_ + 16 - 50) - (float)j), (LivingEntity)pet);
        }
        this.m_280072_(guiGraphics, i, j);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int i, int j) {
        LivingEntity pet;
        super.m_280003_(guiGraphics, i, j);
        if (this.isLoading) {
            MutableComponent text = Component.m_237115_((String)"gui.pickablepets.loading");
            FormattedCharSequence formattedCharSequence = text.m_7532_();
            guiGraphics.m_280614_(this.f_96547_, (Component)text, 220 - this.f_96547_.m_92724_(formattedCharSequence) / 2, 25, 0xFFFFFF, false);
        } else if (this.petIDS == null || this.petIDS.isEmpty()) {
            MutableComponent text = Component.m_237115_((String)"gui.pickablepets.nopets");
            FormattedCharSequence formattedCharSequence = text.m_7532_();
            guiGraphics.m_280614_(this.f_96547_, (Component)text, 220 - this.f_96547_.m_92724_(formattedCharSequence) / 2, 25, 0x404040, false);
        } else if (this.petItem != -1 && (pet = CachedPets.getPet(this.petIDS.get(this.petItem))) != null) {
            int textY = 6;
            MutableComponent text = Component.m_237115_((String)"gui.pickablepets.dim").m_130940_(ChatFormatting.UNDERLINE);
            FormattedCharSequence formattedCharSequence = text.m_7532_();
            guiGraphics.m_280614_(this.f_96547_, (Component)text, 220 - this.f_96547_.m_92724_(formattedCharSequence) / 2, textY, 0xFFFFFF, false);
            text = Component.m_237115_((String)pet.m_9236_().m_46472_().m_135782_().toString());
            formattedCharSequence = text.m_7532_();
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280614_(this.f_96547_, (Component)text, 220 - this.f_96547_.m_92724_(formattedCharSequence) / 2, textY += 9 + 2, 15767114, false);
            text = Component.m_237115_((String)"gui.pickablepets.pos").m_130940_(ChatFormatting.UNDERLINE);
            formattedCharSequence = text.m_7532_();
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280614_(this.f_96547_, (Component)text, 220 - this.f_96547_.m_92724_(formattedCharSequence) / 2, textY += 9 + 3, 0xFFFFFF, false);
            text = CachedPets.isInItem(this.petIDS.get(this.petItem)) ? Component.m_237115_((String)"gui.pickablepets.pos.item") : Component.m_237113_((String)pet.m_20183_().m_123344_());
            formattedCharSequence = text.m_7532_();
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280614_(this.f_96547_, (Component)text, 220 - this.f_96547_.m_92724_(formattedCharSequence) / 2, textY += 9 + 2, 15767114, false);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float f, int i, int j) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280398_(TEXTURE, k, l, 0, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
    }

    private void renderScroller(GuiGraphics guiGraphics, int i, int j) {
        int k = this.petIDS.size() + 1 - 7;
        if (k > 1) {
            int l = 139 - (27 + (k - 1) * 139 / k);
            int m = 1 + l / k + 139 / k;
            int o = Math.min(123, this.scrollOff * m);
            if (this.scrollOff == k - 1) {
                o = 123;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            guiGraphics.m_280163_(TEXTURE, i + 94, j + 17 + o, 288.0f, 0.0f, 6, 16, 512, 256);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            guiGraphics.m_280163_(TEXTURE, i + 94, j + 17, 294.0f, 0.0f, 6, 16, 512, 256);
        }
    }

    private boolean canScroll(int i) {
        return i > 7;
    }

    public boolean m_6050_(double d, double e, double f) {
        if (this.petIDS == null || this.petIDS.isEmpty()) {
            return super.m_6050_(d, e, f);
        }
        int i = this.petIDS.size();
        if (this.canScroll(i)) {
            int j = i - 7;
            this.scrollOff = Mth.m_14045_((int)((int)((double)this.scrollOff - f)), (int)0, (int)j);
        }
        return true;
    }

    public boolean m_7979_(double d, double e, int i, double f, double g) {
        if (this.petIDS == null || this.petIDS.isEmpty()) {
            return super.m_7979_(d, e, i, f, g);
        }
        int j = this.petIDS.size();
        if (this.isDragging) {
            int k = this.f_97736_ + 18;
            int l = k + 139;
            int m = j - 7;
            float h = ((float)e - (float)k - 13.5f) / ((float)(l - k) - 27.0f);
            h = h * (float)m + 0.5f;
            this.scrollOff = Mth.m_14045_((int)((int)h), (int)0, (int)m);
            return true;
        }
        return super.m_7979_(d, e, i, f, g);
    }

    public boolean m_6375_(double d, double e, int i) {
        if (this.petIDS == null || this.petIDS.isEmpty()) {
            return super.m_6375_(d, e, i);
        }
        this.isDragging = false;
        int j = (this.f_96543_ - this.f_97726_) / 2;
        int k = (this.f_96544_ - this.f_97727_) / 2;
        if (this.canScroll(this.petIDS.size()) && d > (double)(j + 94) && d < (double)(j + 94 + 6) && e > (double)(k + 18) && e <= (double)(k + 18 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.m_6375_(d, e, i);
    }

    public boolean m_7043_() {
        return false;
    }
}

