/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.serializer;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.recipe.TemperRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import com.christofmeg.justenoughbreeding.utils.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class TemperSerializer
implements RecipeSerializer<TemperRecipe> {
    @NotNull
    public TemperRecipe fromJson(@NotNull ResourceLocation jsonPath, @NotNull JsonObject json) {
        JsonArray mobs = json.getAsJsonArray("mobs");
        JsonObject mobObject = mobs.get(0).getAsJsonObject();
        Map.Entry mobEntry = (Map.Entry)mobObject.entrySet().iterator().next();
        String modID = json.get("mod").getAsString();
        String mobName = (String)mobEntry.getKey();
        String modFolder = jsonPath.m_135827_();
        String fileName = jsonPath.m_135815_().substring(jsonPath.m_135815_().lastIndexOf(47) + 1);
        if (jsonPath.m_135827_().equals("justenoughbreeding")) {
            modFolder = jsonPath.m_135815_().split("/")[1];
        }
        if (!JustEnoughBreeding.isModLoaded(modFolder).booleanValue() || !JustEnoughBreeding.isModLoaded(modID).booleanValue()) {
            return null;
        }
        EntityType<?> entityType = JustEnoughBreeding.getEntityFromLoaderRegistries(new ResourceLocation(modID, mobName));
        if (entityType == null) {
            throw new JsonParseException("Unknown entity: " + modID + ":" + mobName + " in " + jsonPath);
        }
        if (!mobName.equals(entityType.m_147048_())) {
            throw new JsonParseException("Entity id mismatch. jsonAnimalID=" + mobName + " != " + entityType.m_147048_() + " in " + jsonPath);
        }
        ArrayList<Ingredient> inputIngredients = new ArrayList<Ingredient>();
        ArrayList<Ingredient> extraInputIngredients = new ArrayList<Ingredient>();
        ArrayList<Ingredient> spawnEggs = new ArrayList<Ingredient>();
        JsonObject mobData = ((JsonElement)mobEntry.getValue()).getAsJsonObject();
        this.addIngredients(mobData, inputIngredients, "inputs");
        this.addIngredients(mobData, extraInputIngredients, "extra_inputs");
        if (mobData.has("spawn_eggs")) {
            this.addIngredients(mobData, spawnEggs, "spawn_eggs");
        } else {
            ItemStack spawnEgg = Optional.ofNullable(JustEnoughBreeding.getSpawnEggItem(entityType)).map(Item::m_7968_).orElse(ItemStack.f_41583_);
            spawnEggs = new ArrayList<Ingredient>(List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{spawnEgg})));
        }
        for (TemperRecipe existingRecipe : JustEnoughBreeding.temperRecipes) {
            if (!existingRecipe.jsonModID.equals(modID) || !existingRecipe.jsonAnimalID.equals(mobName)) continue;
            inputIngredients.add(existingRecipe.inputStack);
            spawnEggs.add(existingRecipe.spawnEgg);
            extraInputIngredients.add(existingRecipe.extraInputStack);
            existingRecipe.setInputIngredient(Utils.deduplicateIngredients(inputIngredients));
            existingRecipe.setExtraInputIngredient(Utils.deduplicateIngredients(extraInputIngredients));
            existingRecipe.setSpawnEggs(Utils.deduplicateIngredients(spawnEggs));
            return existingRecipe;
        }
        TemperRecipe newRecipe = new TemperRecipe(entityType, Utils.deduplicateIngredients(inputIngredients), Utils.deduplicateIngredients(spawnEggs), Utils.deduplicateIngredients(extraInputIngredients), modID, mobName, modFolder, fileName);
        JustEnoughBreeding.temperRecipes.add(newRecipe);
        if (newRecipe == null) {
            return null;
        }
        return newRecipe;
    }

    @NotNull
    public TemperRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
        ResourceLocation entityId = buf.m_130281_();
        EntityType<?> entityType = JustEnoughBreeding.getEntityFromLoaderRegistries(entityId);
        if (entityType == null) {
            throw new IllegalStateException("Unknown EntityType in TemperRecipe#fromNetwork: " + entityId);
        }
        Ingredient inputStack = Ingredient.m_43940_((FriendlyByteBuf)buf);
        Ingredient spawnEgg = Ingredient.m_43940_((FriendlyByteBuf)buf);
        boolean hasExtra = buf.readBoolean();
        Ingredient extraInputStack = hasExtra ? Ingredient.m_43940_((FriendlyByteBuf)buf) : Ingredient.f_43901_;
        String jsonModID = buf.m_130277_();
        String jsonAnimalID = buf.m_130277_();
        String modFolder = buf.m_130277_();
        String fileName = buf.m_130277_();
        return new TemperRecipe(entityType, inputStack, spawnEgg, extraInputStack, jsonModID, jsonAnimalID, modFolder, fileName);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull TemperRecipe recipe) {
        ResourceLocation entityKey = JustEnoughBreeding.getKeyLoaderRegistries(recipe.entityType);
        if (entityKey == null) {
            throw new IllegalStateException("Unknown EntityType in TemperRecipe: " + recipe.entityType);
        }
        buf.m_130085_(entityKey);
        CommonUtils.safe(recipe.inputStack).m_43923_(buf);
        CommonUtils.safe(recipe.spawnEgg).m_43923_(buf);
        boolean hasExtra = recipe.extraInputStack != null && !recipe.extraInputStack.m_43947_();
        buf.writeBoolean(hasExtra);
        if (hasExtra) {
            recipe.extraInputStack.m_43923_(buf);
        }
        buf.m_130070_(recipe.jsonModID);
        buf.m_130070_(recipe.jsonAnimalID);
        buf.m_130070_(recipe.modFolder);
        buf.m_130070_(recipe.fileName);
    }

    private void addIngredients(JsonObject mobData, List<Ingredient> ingredientList, String memberName) {
        if (mobData.has(memberName)) {
            for (JsonElement input : mobData.getAsJsonArray(memberName)) {
                CompoundTag nbt = null;
                if (input.getAsJsonObject().has("nbt")) {
                    try {
                        nbt = TagParser.m_129359_((String)input.getAsJsonObject().get("nbt").getAsString());
                    }
                    catch (CommandSyntaxException e) {
                        System.err.println("Invalid NBT data: {}" + input.getAsJsonObject().get("nbt").getAsString());
                    }
                }
                if (!input.getAsJsonObject().has("item")) continue;
                String ingredient = input.getAsJsonObject().get("item").getAsString();
                int temperValue = input.getAsJsonObject().has("value") ? input.getAsJsonObject().get("value").getAsInt() : 1;
                ingredientList.add(Utils.createCombinedIngredient(ingredient, temperValue, nbt));
            }
        }
    }
}

