/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.rei;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.client.ClientUtils;
import com.christofmeg.justenoughbreeding.recipe.AllayDuplicationRecipe;
import com.christofmeg.justenoughbreeding.recipe.BaseRecipe;
import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.recipe.TamingRecipe;
import com.christofmeg.justenoughbreeding.recipe.TemperRecipe;
import com.christofmeg.justenoughbreeding.recipe.TransformationRecipe;
import com.christofmeg.justenoughbreeding.recipe.TrustingRecipe;
import com.christofmeg.justenoughbreeding.rei.AllayDuplicationDisplay;
import com.christofmeg.justenoughbreeding.rei.BreedingDisplay;
import com.christofmeg.justenoughbreeding.rei.TamingDisplay;
import com.christofmeg.justenoughbreeding.rei.TemperDisplay;
import com.christofmeg.justenoughbreeding.rei.TransformationDisplay;
import com.christofmeg.justenoughbreeding.rei.TrustingDisplay;
import com.christofmeg.justenoughbreeding.utils.CommonClientUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.display.Display;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.crafting.RecipeType;

public class REIUtils {
    public static void registerRecipes(DisplayRegistry registration) {
        ArrayList<AllayDuplicationRecipe> allayDuplicationRecipes = new ArrayList<AllayDuplicationRecipe>(registration.getRecipeManager().m_44013_((RecipeType)JustEnoughBreeding.ALLAY_DUPLICATION_PROVIDER_TYPE.get()));
        allayDuplicationRecipes.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
        for (AllayDuplicationRecipe allayDuplicationRecipe : allayDuplicationRecipes) {
            if (!JustEnoughBreeding.isModLoaded(allayDuplicationRecipe.jsonModID).booleanValue() || allayDuplicationRecipe.entityType == null) continue;
            registration.add((Display)new AllayDuplicationDisplay(allayDuplicationRecipe));
        }
        ArrayList<BreedingRecipe> breedingRecipes = new ArrayList<BreedingRecipe>(registration.getRecipeManager().m_44013_((RecipeType)JustEnoughBreeding.BREEDING_PROVIDER_TYPE.get()));
        breedingRecipes.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
        for (BreedingRecipe breedingRecipe : breedingRecipes) {
            if (!JustEnoughBreeding.isModLoaded(breedingRecipe.jsonModID).booleanValue() || breedingRecipe.entityType == null) continue;
            registration.add((Display)new BreedingDisplay(breedingRecipe));
        }
        ArrayList<TamingRecipe> arrayList = new ArrayList<TamingRecipe>(registration.getRecipeManager().m_44013_((RecipeType)JustEnoughBreeding.TAMING_PROVIDER_TYPE.get()));
        arrayList.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
        for (TamingRecipe tamingRecipe : arrayList) {
            if (!JustEnoughBreeding.isModLoaded(tamingRecipe.jsonModID).booleanValue() || tamingRecipe.entityType == null) continue;
            registration.add((Display)new TamingDisplay(tamingRecipe));
        }
        ArrayList<TemperRecipe> arrayList2 = new ArrayList<TemperRecipe>(registration.getRecipeManager().m_44013_((RecipeType)JustEnoughBreeding.TEMPER_PROVIDER_TYPE.get()));
        arrayList2.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
        for (TemperRecipe temperRecipe : arrayList2) {
            if (!JustEnoughBreeding.isModLoaded(temperRecipe.jsonModID).booleanValue() || temperRecipe.entityType == null) continue;
            registration.add((Display)new TemperDisplay(temperRecipe));
        }
        ArrayList<TransformationRecipe> arrayList3 = new ArrayList<TransformationRecipe>(registration.getRecipeManager().m_44013_((RecipeType)JustEnoughBreeding.TRANSFORMATION_PROVIDER_TYPE.get()));
        arrayList3.sort(Comparator.comparing(r -> r.outputEntityType == null ? r.fileName : r.outputEntityType.m_147048_()));
        for (TransformationRecipe recipe : arrayList3) {
            if (!JustEnoughBreeding.isModLoaded(recipe.jsonModID).booleanValue() || recipe.inputEntityType == null || recipe.outputEntityType == null) continue;
            registration.add((Display)new TransformationDisplay(recipe));
        }
        ArrayList<TrustingRecipe> arrayList4 = new ArrayList<TrustingRecipe>(registration.getRecipeManager().m_44013_((RecipeType)JustEnoughBreeding.TRUSTING_PROVIDER_TYPE.get()));
        arrayList4.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
        for (TrustingRecipe recipe : arrayList4) {
            if (!JustEnoughBreeding.isModLoaded(recipe.jsonModID).booleanValue() || recipe.entityType == null) continue;
            registration.add((Display)new TrustingDisplay(recipe));
        }
    }

    public static void drawMobSlot(List<Widget> widgets, Rectangle bounds, int mobSlotX, int mobSlotY) {
        widgets.add((Widget)Widgets.createSlotBase((Rectangle)new Rectangle(bounds.x + 5 + mobSlotX, bounds.y + 5 + mobSlotY, 61, 81)));
    }

    public static void drawMobNameAndEntity(List<Widget> widgets, Rectangle bounds, EntityType<?> entityType, BaseRecipe recipe) {
        REIUtils.drawMobNameAndEntity(widgets, bounds, entityType, recipe, 148, 0);
    }

    public static void drawMobNameAndEntity(List<Widget> widgets, Rectangle bounds, EntityType<?> entityType, BaseRecipe recipe, int availableWidth, int extraX) {
        REIUtils.drawMobNameAndEntity(widgets, bounds, entityType, recipe, availableWidth, extraX, true, null);
    }

    public static void drawMobNameAndEntity(List<Widget> widgets, Rectangle bounds, EntityType<?> entityType, BaseRecipe recipe, int availableWidth, int extraX, boolean input, DyeColor color) {
        if (entityType != null) {
            Font font = Minecraft.m_91087_().f_91062_;
            MutableComponent entityName = Component.m_237115_((String)entityType.m_20675_());
            Object entityNameString = entityName.getString();
            if (recipe instanceof BreedingRecipe) {
                BreedingRecipe breedingRecipe = (BreedingRecipe)recipe;
                if (breedingRecipe.needsToBeTamed != null && breedingRecipe.needsToBeTamed.booleanValue()) {
                    tamed = Component.m_237115_((String)"translation.justenoughbreeding.tamed");
                    entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
                } else if (breedingRecipe.animalTrusting != null && breedingRecipe.animalTrusting.booleanValue()) {
                    MutableComponent trusting = Component.m_237115_((String)"translation.justenoughbreeding.trusting");
                    entityNameString = (String)entityNameString + " (" + trusting.getString() + ")";
                } else if ("tfc".equals(breedingRecipe.jsonModID)) {
                    MutableComponent familiarity = Component.m_237115_((String)"tfc.jade.familiarity");
                    String tfc = familiarity.getString().replaceAll(":[^:]*$", "");
                    entityNameString = (String)entityNameString + " (" + tfc + " > 30)";
                }
            } else if (recipe instanceof TransformationRecipe) {
                TransformationRecipe transformationRecipe = (TransformationRecipe)recipe;
                if (input && transformationRecipe.needsToBeTamed != null && transformationRecipe.needsToBeTamed.booleanValue()) {
                    tamed = Component.m_237115_((String)"translation.justenoughbreeding.tamed");
                    entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
                }
            }
            int stringWidth = font.m_92895_((String)entityNameString);
            if (stringWidth > availableWidth) {
                float pixelWidthPerCharacter = (float)stringWidth / (float)Math.max(1, ((String)entityNameString).length());
                int maxCharacters = Math.max(0, (int)((float)availableWidth / pixelWidthPerCharacter));
                entityNameString = ((String)entityNameString).substring(0, Math.min(((String)entityNameString).length(), maxCharacters));
            }
            if (!((String)entityNameString).isEmpty()) {
                Component abbreviatedEntityName = Component.m_130674_((String)entityNameString);
                widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.x + extraX + 5, bounds.y + 5), (Component)abbreviatedEntityName).leftAligned().noShadow().color(-12566464, -4473925));
            }
            LivingEntity currentLivingEntity = recipe instanceof TransformationRecipe ? ClientUtils.doRendering(entityType, input, color) : ClientUtils.doRendering(entityType);
            widgets.add((Widget)Widgets.withTranslate((Widget)Widgets.createDrawableWidget((graphics, mouseX, mouseY, v) -> {
                if (currentLivingEntity != null) {
                    CommonClientUtils.renderEntity(graphics.m_280168_(), mouseX, currentLivingEntity, 31 + extraX, 89);
                }
            }), (double)(bounds.x + 5), (double)(bounds.y + 5), (double)0.0));
        }
    }
}

