/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.recipe;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.recipe.BaseRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransformationRecipe
extends BaseRecipe {
    public final EntityType<?> inputEntityType;
    @NotNull
    public Ingredient inputStack;
    @NotNull
    public Ingredient inputSpawnEgg;
    @NotNull
    public Ingredient extraInputStack;
    public final EntityType<?> outputEntityType;
    @NotNull
    public Ingredient outputSpawnEgg;
    @Nullable
    public final Boolean needsToBeTamed;
    public final String jsonModID;
    public final String modFolder;
    public final String fileName;
    @Nullable
    public final DyeColor inputColor;
    @Nullable
    public final DyeColor outputColor;

    public TransformationRecipe(EntityType<?> inputEntityType, Ingredient inputStack, Ingredient inputSpawnEgg, Ingredient extraInputStack, EntityType<?> outputEntityType, Ingredient outputSpawnEgg, @Nullable Boolean needsToBeTamed, String jsonModID, String modFolder, String fileName, @Nullable DyeColor inputColor, @Nullable DyeColor outputColor) {
        this.inputEntityType = Objects.requireNonNull(inputEntityType, "inputEntityType");
        this.inputStack = CommonUtils.safe(inputStack);
        this.inputSpawnEgg = CommonUtils.safe(inputSpawnEgg);
        this.extraInputStack = CommonUtils.safe(extraInputStack);
        this.outputEntityType = Objects.requireNonNull(outputEntityType, "outputEntityType");
        this.outputSpawnEgg = CommonUtils.safe(outputSpawnEgg);
        this.needsToBeTamed = needsToBeTamed;
        this.jsonModID = Objects.requireNonNull(jsonModID, "jsonModID");
        this.modFolder = Objects.requireNonNull(modFolder, "modFolder");
        this.fileName = Objects.requireNonNull(fileName, "fileName");
        this.inputColor = inputColor;
        this.outputColor = outputColor;
        this.validateRequired();
    }

    private void validateRequired() {
        if (this.inputStack.m_43947_()) {
            throw new IllegalStateException("TransformationRecipe " + this.m_6423_() + " has empty input ingredient.");
        }
        if (this.inputSpawnEgg.m_43947_()) {
            throw new IllegalStateException("TransformationRecipe " + this.m_6423_() + " has empty inputSpawnEgg ingredient.");
        }
        if (this.outputSpawnEgg.m_43947_()) {
            throw new IllegalStateException("TransformationRecipe " + this.m_6423_() + " has empty outputSpawnEgg ingredient.");
        }
    }

    @Override
    @NotNull
    public ResourceLocation m_6423_() {
        return new ResourceLocation("justenoughbreeding", "transformation/" + this.modFolder + "/" + this.fileName + "/" + this.jsonModID);
    }

    @Override
    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)JustEnoughBreeding.TRANSFORMATION_PROVIDER_SERIALIZER.get();
    }

    @Override
    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)JustEnoughBreeding.TRANSFORMATION_PROVIDER_TYPE.get();
    }

    public void setInputIngredient(Ingredient ingredient) {
        this.inputStack = CommonUtils.safe(ingredient);
    }

    public void setExtraInputIngredient(Ingredient ingredient) {
        this.extraInputStack = CommonUtils.safe(ingredient);
    }

    public void setInputSpawnEggs(Ingredient ingredient) {
        this.inputSpawnEgg = CommonUtils.safe(ingredient);
    }

    public void setOutputSpawnEggs(Ingredient ingredient) {
        this.outputSpawnEgg = CommonUtils.safe(ingredient);
    }
}

