/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.jei;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.client.ClientUtils;
import com.christofmeg.justenoughbreeding.jei.AllayDuplicationCategory;
import com.christofmeg.justenoughbreeding.jei.BreedingCategory;
import com.christofmeg.justenoughbreeding.jei.TamingCategory;
import com.christofmeg.justenoughbreeding.jei.TemperCategory;
import com.christofmeg.justenoughbreeding.jei.TransformationCategory;
import com.christofmeg.justenoughbreeding.jei.TrustingCategory;
import com.christofmeg.justenoughbreeding.recipe.AllayDuplicationRecipe;
import com.christofmeg.justenoughbreeding.recipe.BaseRecipe;
import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.recipe.TamingRecipe;
import com.christofmeg.justenoughbreeding.recipe.TemperRecipe;
import com.christofmeg.justenoughbreeding.recipe.TransformationRecipe;
import com.christofmeg.justenoughbreeding.recipe.TrustingRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonClientUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.crafting.RecipeType;

public class JEIUtils {
    public static void registerRecipes(IRecipeRegistration registration) {
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        if (clientLevel != null) {
            ArrayList<AllayDuplicationRecipe> allayDuplicationRecipes = new ArrayList<AllayDuplicationRecipe>(clientLevel.m_7465_().m_44013_((RecipeType)JustEnoughBreeding.ALLAY_DUPLICATION_PROVIDER_TYPE.get()));
            allayDuplicationRecipes.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
            for (AllayDuplicationRecipe allayDuplicationRecipe : allayDuplicationRecipes) {
                if (!JustEnoughBreeding.isModLoaded(allayDuplicationRecipe.jsonModID).booleanValue() || allayDuplicationRecipe.entityType == null) continue;
                registration.addRecipes(AllayDuplicationCategory.TYPE, Collections.singletonList(allayDuplicationRecipe));
            }
            ArrayList<BreedingRecipe> breedingRecipes = new ArrayList<BreedingRecipe>(clientLevel.m_7465_().m_44013_((RecipeType)JustEnoughBreeding.BREEDING_PROVIDER_TYPE.get()));
            breedingRecipes.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
            for (BreedingRecipe breedingRecipe : breedingRecipes) {
                if (!JustEnoughBreeding.isModLoaded(breedingRecipe.jsonModID).booleanValue() || breedingRecipe.entityType == null) continue;
                registration.addRecipes(BreedingCategory.TYPE, Collections.singletonList(breedingRecipe));
            }
            ArrayList<TamingRecipe> arrayList = new ArrayList<TamingRecipe>(clientLevel.m_7465_().m_44013_((RecipeType)JustEnoughBreeding.TAMING_PROVIDER_TYPE.get()));
            arrayList.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
            for (TamingRecipe tamingRecipe : arrayList) {
                if (!JustEnoughBreeding.isModLoaded(tamingRecipe.jsonModID).booleanValue() || tamingRecipe.entityType == null) continue;
                registration.addRecipes(TamingCategory.TYPE, Collections.singletonList(tamingRecipe));
            }
            ArrayList<TemperRecipe> arrayList2 = new ArrayList<TemperRecipe>(clientLevel.m_7465_().m_44013_((RecipeType)JustEnoughBreeding.TEMPER_PROVIDER_TYPE.get()));
            arrayList2.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
            for (TemperRecipe temperRecipe : arrayList2) {
                if (!JustEnoughBreeding.isModLoaded(temperRecipe.jsonModID).booleanValue() || temperRecipe.entityType == null) continue;
                registration.addRecipes(TemperCategory.TYPE, Collections.singletonList(temperRecipe));
            }
            ArrayList<TransformationRecipe> arrayList3 = new ArrayList<TransformationRecipe>(clientLevel.m_7465_().m_44013_((RecipeType)JustEnoughBreeding.TRANSFORMATION_PROVIDER_TYPE.get()));
            arrayList3.sort(Comparator.comparing(r -> r.outputEntityType == null ? r.fileName : r.outputEntityType.m_147048_()));
            for (TransformationRecipe recipe : arrayList3) {
                if (!JustEnoughBreeding.isModLoaded(recipe.jsonModID).booleanValue() || recipe.inputEntityType == null || recipe.outputEntityType == null) continue;
                registration.addRecipes(TransformationCategory.TYPE, Collections.singletonList(recipe));
            }
            ArrayList<TrustingRecipe> arrayList4 = new ArrayList<TrustingRecipe>(clientLevel.m_7465_().m_44013_((RecipeType)JustEnoughBreeding.TRUSTING_PROVIDER_TYPE.get()));
            arrayList4.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
            for (TrustingRecipe recipe : arrayList4) {
                if (!JustEnoughBreeding.isModLoaded(recipe.jsonModID).booleanValue() || recipe.entityType == null) continue;
                registration.addRecipes(TrustingCategory.TYPE, Collections.singletonList(recipe));
            }
        }
    }

    public static void drawMobSlot(int mobSlotX, int mobSlotY, IDrawableStatic bigSlot, GuiGraphics stack) {
        bigSlot.draw(stack, mobSlotX, mobSlotY, 0, 1, 0, 1);
        bigSlot.draw(stack, mobSlotX + 18, mobSlotY, 0, 1, 1, 1);
        bigSlot.draw(stack, mobSlotX + 32, mobSlotY, 0, 1, 1, 1);
        bigSlot.draw(stack, mobSlotX + 35, mobSlotY, 0, 1, 22, 0);
        bigSlot.draw(stack, mobSlotX, mobSlotY + 24, 1, 1, 0, 1);
        bigSlot.draw(stack, mobSlotX + 18, mobSlotY + 24, 1, 1, 1, 1);
        bigSlot.draw(stack, mobSlotX + 32, mobSlotY + 24, 1, 1, 1, 1);
        bigSlot.draw(stack, mobSlotX + 35, mobSlotY + 24, 1, 1, 22, 0);
        bigSlot.draw(stack, mobSlotX, mobSlotY + 48, 1, 1, 0, 1);
        bigSlot.draw(stack, mobSlotX + 18, mobSlotY + 48, 1, 1, 1, 1);
        bigSlot.draw(stack, mobSlotX + 32, mobSlotY + 48, 1, 1, 1, 1);
        bigSlot.draw(stack, mobSlotX + 35, mobSlotY + 48, 1, 1, 22, 0);
        bigSlot.draw(stack, mobSlotX, mobSlotY + 55, 18, 0, 0, 1);
        bigSlot.draw(stack, mobSlotX + 18, mobSlotY + 55, 18, 0, 1, 1);
        bigSlot.draw(stack, mobSlotX + 32, mobSlotY + 55, 18, 0, 1, 1);
        bigSlot.draw(stack, mobSlotX + 35, mobSlotY + 55, 18, 0, 22, 0);
    }

    public static void drawMobNameAndEntity(EntityType<?> entityType, GuiGraphics stack, double mouseX, BaseRecipe recipe) {
        JEIUtils.drawMobNameAndEntity(entityType, stack, mouseX, recipe, 148, 0);
    }

    public static void drawMobNameAndEntity(EntityType<?> entityType, GuiGraphics stack, double mouseX, BaseRecipe recipe, int availableWidth, int extraX) {
        JEIUtils.drawMobNameAndEntity(entityType, stack, mouseX, recipe, availableWidth, extraX, true, null);
    }

    public static void drawMobNameAndEntity(EntityType<?> entityType, GuiGraphics stack, double mouseX, BaseRecipe recipe, int availableWidth, int extraX, boolean input, DyeColor color) {
        if (entityType != null) {
            LivingEntity currentLivingEntity;
            Font font = Minecraft.m_91087_().f_91062_;
            MutableComponent entityName = Component.m_237115_((String)entityType.m_20675_());
            Object entityNameString = entityName.getString();
            if (recipe instanceof BreedingRecipe) {
                BreedingRecipe breedingRecipe = (BreedingRecipe)recipe;
                if (breedingRecipe.needsToBeTamed != null && breedingRecipe.needsToBeTamed.booleanValue()) {
                    tamed = Component.m_237115_((String)"translation.justenoughbreeding.tamed");
                    entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
                } else if (breedingRecipe.animalTrusting != null && breedingRecipe.animalTrusting.booleanValue()) {
                    MutableComponent trusting = Component.m_237115_((String)"translation.justenoughbreeding.trusting");
                    entityNameString = (String)entityNameString + " (" + trusting.getString() + ")";
                } else if ("tfc".equals(breedingRecipe.jsonModID)) {
                    MutableComponent familiarity = Component.m_237115_((String)"tfc.jade.familiarity");
                    String tfc = familiarity.getString().replaceAll(":[^:]*$", "");
                    entityNameString = (String)entityNameString + " (" + tfc + " > 30)";
                }
            } else if (recipe instanceof TransformationRecipe) {
                TransformationRecipe transformationRecipe = (TransformationRecipe)recipe;
                if (input && transformationRecipe.needsToBeTamed != null && transformationRecipe.needsToBeTamed.booleanValue()) {
                    tamed = Component.m_237115_((String)"translation.justenoughbreeding.tamed");
                    entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
                }
            }
            int stringWidth = font.m_92895_((String)entityNameString);
            if (stringWidth > availableWidth) {
                float pixelWidthPerCharacter = (float)stringWidth / (float)Math.max(1, ((String)entityNameString).length());
                int maxCharacters = Math.max(0, (int)((float)availableWidth / pixelWidthPerCharacter));
                entityNameString = ((String)entityNameString).substring(0, Math.min(((String)entityNameString).length(), maxCharacters));
            }
            if (!((String)entityNameString).isEmpty()) {
                Component abbreviatedEntityName = Component.m_130674_((String)entityNameString);
                stack.m_280614_(font, abbreviatedEntityName, extraX, 0, DyeColor.BLACK.m_41071_(), false);
            }
            LivingEntity livingEntity = currentLivingEntity = recipe instanceof TransformationRecipe ? ClientUtils.doRendering(entityType, input, color) : ClientUtils.doRendering(entityType);
            if (currentLivingEntity != null) {
                CommonClientUtils.renderEntity(stack.m_280168_(), mouseX, currentLivingEntity, 31 + extraX, 89);
            }
        }
    }
}

