/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.common.create.behaviour;

import cc.tweaked_programs.cccbridge.common.minecraft.block.AnimatronicBlock;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleItem;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import net.createmod.catnip.data.Iterate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class AnimatronicInteractionBehaviour
extends MovingInteractionBehaviour {
    public boolean handlePlayerInteraction(Player player, InteractionHand activeHand, BlockPos localPos, AbstractContraptionEntity contraptionEntity) {
        ItemStack itemInHand = player.m_21120_(activeHand);
        if (!(contraptionEntity instanceof CarriageContraptionEntity)) {
            return false;
        }
        CarriageContraptionEntity carriageEntity = (CarriageContraptionEntity)contraptionEntity;
        if (activeHand == InteractionHand.OFF_HAND) {
            return false;
        }
        Contraption contraption = carriageEntity.getContraption();
        if (!(contraption instanceof CarriageContraption)) {
            return false;
        }
        CarriageContraption carriageContraption = (CarriageContraption)contraption;
        Direction assemblyDirection = carriageContraption.getAssemblyDirection();
        for (Direction direction : Iterate.directionsInAxis((Direction.Axis)assemblyDirection.m_122434_())) {
            if (!carriageContraption.inControl(localPos, direction)) continue;
            Train train = carriageEntity.getCarriage().train;
            if (train == null) {
                return false;
            }
            if (player.m_9236_().f_46443_) {
                return true;
            }
            this.setHasJobState(localPos, contraptionEntity, false);
            if (train.runtime.getSchedule() != null) {
                if (train.runtime.paused && !train.runtime.completed) {
                    train.runtime.paused = false;
                    AllSoundEvents.CONFIRM.playOnServer(player.m_9236_(), (Vec3i)player.m_20183_(), 1.0f, 1.0f);
                    player.m_5661_((Component)Component.m_237115_((String)"schedule.continued"), true);
                    return true;
                }
                if (!itemInHand.m_41619_()) {
                    AllSoundEvents.DENY.playOnServer(player.m_9236_(), (Vec3i)player.m_20183_(), 1.0f, 1.0f);
                    player.m_5661_((Component)Component.m_237115_((String)"schedule.remove_with_empty_hand"), true);
                    return true;
                }
                AllSoundEvents.playItemPickup((Player)player);
                player.m_5661_((Component)Component.m_237115_((String)(train.runtime.isAutoSchedule ? "schedule.auto_removed_from_train" : "schedule.removed_from_train")), true);
                player.m_21008_(activeHand, train.runtime.returnSchedule());
                return true;
            }
            if (!AllItems.SCHEDULE.isIn(itemInHand)) {
                return true;
            }
            Schedule schedule = ScheduleItem.getSchedule((ItemStack)itemInHand);
            if (schedule == null) {
                return false;
            }
            if (schedule.entries.isEmpty()) {
                AllSoundEvents.DENY.playOnServer(player.m_9236_(), (Vec3i)player.m_20183_(), 1.0f, 1.0f);
                player.m_5661_((Component)Component.m_237115_((String)"schedule.no_stops"), true);
                return true;
            }
            this.setHasJobState(localPos, contraptionEntity, true);
            train.runtime.setSchedule(schedule, false);
            AllAdvancements.CONDUCTOR.awardTo(player);
            AllSoundEvents.CONFIRM.playOnServer(player.m_9236_(), (Vec3i)player.m_20183_(), 1.0f, 1.0f);
            player.m_5661_((Component)Component.m_237115_((String)"schedule.applied_to_train").m_130940_(ChatFormatting.GREEN), true);
            itemInHand.m_41774_(1);
            player.m_21008_(activeHand, itemInHand.m_41619_() ? ItemStack.f_41583_ : itemInHand);
            return true;
        }
        player.m_5661_((Component)Component.m_237115_((String)"schedule.non_controlling_seat"), true);
        AllSoundEvents.DENY.playOnServer(player.m_9236_(), (Vec3i)player.m_20183_(), 1.0f, 1.0f);
        return true;
    }

    private void setHasJobState(BlockPos localPos, AbstractContraptionEntity contraption, boolean value) {
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getContraption().getBlocks().get(localPos);
        if (info != null && info.f_74676_().m_60734_() instanceof AnimatronicBlock) {
            BlockState newState = (BlockState)info.f_74676_().m_61124_((Property)AnimatronicBlock.IS_DRIVER, (Comparable)Boolean.valueOf(value));
            this.setContraptionBlockData(contraption, localPos, new StructureTemplate.StructureBlockInfo(info.f_74675_(), newState, info.f_74677_()));
        }
    }
}

