/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.client.animatronic;

import cc.tweaked_programs.cccbridge.client.blockEntityRenderer.AnimatronicBlockEntityRenderer;
import cc.tweaked_programs.cccbridge.common.assistance.animatronic.Face;
import cc.tweaked_programs.cccbridge.common.minecraft.blockEntity.AnimatronicBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AnimatronicModel<T extends AnimatronicBlockEntity>
extends Model {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("cccbridge", "animatronic"), "main");
    private static final float awesomeFactor = (float)Math.PI / 180;
    private final ModelPart root;
    private final ModelPart hat;
    private final ModelPart support;

    public AnimatronicModel(ModelPart root) {
        super(RenderType::m_110473_);
        this.root = root.m_171324_("root");
        this.support = root.m_171324_("support");
        this.hat = this.root.m_171324_("head").m_171324_("hat");
        this.hat.f_104207_ = false;
    }

    public void hasJob(boolean value) {
        this.hat.f_104207_ = value;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_().m_171514_(8, 32).m_171488_(-1.0f, -7.0f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 20).m_171488_(-3.0f, -5.0f, -3.0f, 6.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(26, 20).m_171488_(-6.0f, -3.5f, -1.5f, 12.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)0.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)-1.0f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-2.0f, -2.0f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(52, 7).m_171488_(-2.05f, -0.85f, -2.6f, 4.15f, 1.0f, 1.5f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)0.0f));
        PartDefinition nose_r1 = hat.m_171599_("nose_r1", CubeListBuilder.m_171558_().m_171514_(40, 7).m_171488_(-1.975f, 0.0f, -4.4f, 3.95f, 0.5f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition face = head.m_171599_("face", CubeListBuilder.m_171558_().m_171514_(40, 10).m_171488_(-5.0f, -9.0f, -5.025f, 10.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = root.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition leftarm = root.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(20, 20).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition support = partdefinition.m_171599_("support", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)22.0f, (float)0.0f));
        PartDefinition upper_arm_r1 = support.m_171599_("upper_arm_r1", CubeListBuilder.m_171558_().m_171514_(0, 47).m_171488_(7.5f, 2.775f, -6.725f, 1.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.0f, (float)-7.0f, (float)7.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition lower_arm_r1 = support.m_171599_("lower_arm_r1", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171488_(7.5f, -1.0f, -5.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.0f, (float)-0.25f, (float)7.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float partialTicks, float netHeadYaw, float headPitch) {
        if (((AnimatronicBlockEntity)entity).isMoving()) {
            ((AnimatronicBlockEntity)entity).updateCurrentPoses(partialTicks);
        }
        float facing = (((Direction)entity.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122435_() + ((AnimatronicBlockEntity)entity).getBodyPose().m_123157_()) * ((float)Math.PI / 180);
        this.root.m_171324_((String)"head").f_104203_ = ((AnimatronicBlockEntity)entity).getHeadPose().m_123156_() * ((float)Math.PI / 180);
        this.root.m_171324_((String)"head").f_104204_ = ((AnimatronicBlockEntity)entity).getHeadPose().m_123157_() * ((float)Math.PI / 180);
        this.root.m_171324_((String)"head").f_104205_ = ((AnimatronicBlockEntity)entity).getHeadPose().m_123158_() * ((float)Math.PI / 180);
        this.root.f_104203_ = ((AnimatronicBlockEntity)entity).getBodyPose().m_123156_() * ((float)Math.PI / 180);
        this.root.f_104204_ = facing;
        this.root.f_104205_ = ((AnimatronicBlockEntity)entity).getBodyPose().m_123158_() * ((float)Math.PI / 180);
        this.support.f_104203_ = 0.0f;
        this.support.f_104204_ = facing;
        this.support.f_104205_ = 0.0f;
        this.root.m_171324_((String)"leftarm").f_104203_ = ((AnimatronicBlockEntity)entity).getLeftArmPose().m_123156_() * ((float)Math.PI / 180);
        this.root.m_171324_((String)"leftarm").f_104204_ = ((AnimatronicBlockEntity)entity).getLeftArmPose().m_123157_() * ((float)Math.PI / 180);
        this.root.m_171324_((String)"leftarm").f_104205_ = ((AnimatronicBlockEntity)entity).getLeftArmPose().m_123158_() * ((float)Math.PI / 180);
        this.root.m_171324_((String)"rightarm").f_104203_ = ((AnimatronicBlockEntity)entity).getRightArmPose().m_123156_() * ((float)Math.PI / 180);
        this.root.m_171324_((String)"rightarm").f_104204_ = ((AnimatronicBlockEntity)entity).getRightArmPose().m_123157_() * ((float)Math.PI / 180);
        this.root.m_171324_((String)"rightarm").f_104205_ = ((AnimatronicBlockEntity)entity).getRightArmPose().m_123158_() * ((float)Math.PI / 180);
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.support.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public static ResourceLocation getFace(AnimatronicBlockEntity be) {
        Face face = be.getFace();
        if (face == null) {
            return AnimatronicBlockEntityRenderer.TEXTURE_FACE_NORMAL;
        }
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case Face.NORMAL -> AnimatronicBlockEntityRenderer.TEXTURE_FACE_NORMAL;
            case Face.HAPPY -> AnimatronicBlockEntityRenderer.TEXTURE_FACE_HAPPY;
            case Face.QUESTION -> AnimatronicBlockEntityRenderer.TEXTURE_FACE_QUESTION;
            case Face.SAD -> AnimatronicBlockEntityRenderer.TEXTURE_FACE_SAD;
        };
    }
}

