/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.DamageData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.items.equipment.DETier;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import com.google.common.collect.Multimap;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface IModularTieredItem
extends IModularItem {
    public DETier getItemTier();

    @Override
    default public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap<Attribute, AttributeModifier> map = IModularItem.super.getAttributeModifiers(slot, stack);
        if (stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
            DETier tier = this.getItemTier();
            if (slot == EquipmentSlot.MAINHAND) {
                ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
                double damage = this.getAttackDamage(host, stack);
                double speed = 1.0 + host.getModuleData(ModuleTypes.SPEED, new SpeedData(0.0)).speedMultiplier();
                map.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(Item.f_41374_, "Tool modifier", damage, AttributeModifier.Operation.ADDITION));
                map.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(Item.f_41375_, "Tool modifier", (double)tier.getAttackSpeed() * this.getSwingSpeedMultiplier() * speed - 4.0, AttributeModifier.Operation.ADDITION));
            }
        }
        return map;
    }

    default public double getAttackDamage(ModuleHost host, ItemStack stack) {
        double damage = host.getModuleData(ModuleTypes.DAMAGE, new DamageData(0.0)).damagePoints();
        if ((double)this.getEnergyStored(stack) < (double)EquipCfg.energyAttack * damage) {
            damage = 0.0;
        }
        return damage + ((double)this.getItemTier().m_6631_() * this.getDamageMultiplier() - 1.0);
    }

    public double getSwingSpeedMultiplier();

    public double getDamageMultiplier();
}

