/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.ApproachPositionPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.ArialBombardPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.BombardPlayerPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.ChargingPlayerPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.CoverFirePhase;
import com.brandon3055.draconicevolution.entity.guardian.control.DyingPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.GroundEffectPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.HoverPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.IPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.LaserBeamPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.ShockwavePhase;
import com.brandon3055.draconicevolution.entity.guardian.control.StartPhase;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import net.minecraft.util.random.SimpleWeightedRandomList;

public class PhaseType<T extends IPhase> {
    private static PhaseType<?>[] phases = new PhaseType[0];
    public static final PhaseType<StartPhase> START = PhaseType.create(StartPhase.class, "HoldingPattern");
    public static final PhaseType<CoverFirePhase> COVER_FIRE = PhaseType.create(CoverFirePhase.class, "CoverFire");
    public static final PhaseType<ApproachPositionPhase> APPROACH_POSITION = PhaseType.create(ApproachPositionPhase.class, "ApproachPos");
    public static final PhaseType<ChargingPlayerPhase> CHARGE_PLAYER = PhaseType.create(ChargingPlayerPhase.class, "ChargingPlayer");
    public static final PhaseType<BombardPlayerPhase> BOMBARD_PLAYER = PhaseType.create(BombardPlayerPhase.class, "BombardPlayer");
    public static final PhaseType<DyingPhase> DYING = PhaseType.create(DyingPhase.class, "Dying");
    public static final PhaseType<HoverPhase> HOVER = PhaseType.create(HoverPhase.class, "Hover");
    public static final PhaseType<LaserBeamPhase> LASER_BEAM = PhaseType.create(LaserBeamPhase.class, "LaserBeam");
    public static final PhaseType<ShockwavePhase> SHOCKWAVE = PhaseType.create(ShockwavePhase.class, "ShockWave");
    public static final PhaseType<GroundEffectPhase> GROUND_EFFECTS = PhaseType.create(GroundEffectPhase.class, "GroundEffects");
    public static final PhaseType<ArialBombardPhase> ARIAL_BOMBARD = PhaseType.create(ArialBombardPhase.class, "ArialBombard");
    public static SimpleWeightedRandomList<PhaseType<?>> NORMAL_WEIGHTED;
    public static SimpleWeightedRandomList<PhaseType<?>> AGGRESSIVE_WEIGHTED;
    private final Class<? extends IPhase> clazz;
    private final int id;
    private final String name;

    public static void initPhaseWeights() {
        NORMAL_WEIGHTED = SimpleWeightedRandomList.m_146263_().m_146271_(CHARGE_PLAYER, 100).m_146271_(BOMBARD_PLAYER, 200).m_146271_(LASER_BEAM, 60).m_146271_(GROUND_EFFECTS, 50).m_146271_(ARIAL_BOMBARD, 70).m_146270_();
        AGGRESSIVE_WEIGHTED = SimpleWeightedRandomList.m_146263_().m_146271_(BOMBARD_PLAYER, 50).m_146271_(LASER_BEAM, 150).m_146271_(GROUND_EFFECTS, 50).m_146271_(ARIAL_BOMBARD, 150).m_146270_();
    }

    private PhaseType(int idIn, Class<? extends IPhase> clazzIn, String nameIn) {
        this.id = idIn;
        this.clazz = clazzIn;
        this.name = nameIn;
    }

    public IPhase createPhase(DraconicGuardianEntity guardisn) {
        try {
            Constructor<IPhase> constructor = this.getConstructor();
            return constructor.newInstance(new Object[]{guardisn});
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    protected Constructor<? extends IPhase> getConstructor() throws NoSuchMethodException {
        return this.clazz.getConstructor(DraconicGuardianEntity.class);
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.name + " (#" + this.id + ")";
    }

    public static PhaseType<?> getById(int idIn) {
        return idIn >= 0 && idIn < phases.length ? phases[idIn] : START;
    }

    public static int getTotalPhases() {
        return phases.length;
    }

    private static <T extends IPhase> PhaseType<T> create(Class<T> phaseIn, String nameIn) {
        PhaseType<T> phasetype = new PhaseType<T>(phases.length, phaseIn, nameIn);
        phases = Arrays.copyOf(phases, phases.length + 1);
        PhaseType.phases[phasetype.getId()] = phasetype;
        return phasetype;
    }

    static {
        PhaseType.initPhaseWeights();
    }
}

