/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorInjector;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorStabilizer;
import com.brandon3055.draconicevolution.init.DEContent;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.Map;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class RenderTileReactorComponent
implements BlockEntityRenderer<TileReactorComponent> {
    private static final RenderType STAB_FRAME_TYPE = RenderType.m_110446_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/block/reactor/reactor_stabilizer.png"));
    private static final RenderType INJECTOR_FRAME_TYPE = RenderType.m_110446_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/block/reactor/reactor_injector.png"));
    private static final RenderType STAB_GLOW_TYPE = RenderType.m_173215_((String)"draconicevolution:stab_glow", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/block/reactor/reactor_stabilizer.png"), false, false)).m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172661_)).m_110685_(RenderStateShard.f_110136_).m_110691_(false));
    private static final RenderType INJECTOR_GLOW_TYPE = RenderType.m_173215_((String)"draconicevolution:injector_glow", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/block/reactor/reactor_injector.png"), false, false)).m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172661_)).m_110685_(RenderStateShard.f_110136_).m_110691_(false));
    private static CCModel modelInjectorBase;
    private static CCModel modelInjectorEmitters;
    private static CCModel modelStabFrame;
    private static CCModel modelStabInnerRotor;
    private static CCModel modelStabInnerRotorArm;
    private static CCModel modelStabOuterRotor;
    private static CCModel modelStabOuterRotorArm;
    private static CCModel modelStabRing;
    private static CCModel modelStabRingEmitter;
    private static CCModel modelInnerRotorPart;
    private static CCModel modelOuterRotorPart;

    public RenderTileReactorComponent(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileReactorComponent te, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        Matrix4 mat = new Matrix4(mStack);
        mat.translate(0.5, 0.0, 0.5);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        switch ((Direction)te.facing.get()) {
            case SOUTH: {
                mat.rotate(3.1415926535897403, Vector3.Y_POS);
                break;
            }
            case EAST: {
                mat.rotate(-1.5707963267948701, Vector3.Y_POS);
                break;
            }
            case WEST: {
                mat.rotate(1.5707963267948701, Vector3.Y_POS);
                break;
            }
            case UP: {
                mat.apply(new Rotation(1.5707963267948701, Vector3.X_POS).at(new Vector3(0.0, 0.5, 0.0)));
                break;
            }
            case DOWN: {
                mat.apply(new Rotation(-1.5707963267948701, Vector3.X_POS).at(new Vector3(0.0, 0.5, 0.0)));
            }
        }
        if (te instanceof TileReactorStabilizer) {
            float coreRotation = te.animRotation + partialTicks * te.animRotationSpeed;
            RenderTileReactorComponent.renderStabilizer(ccrs, mat, getter, coreRotation, te.animRotationSpeed / 15.0f, packedLight, packedOverlay);
        } else if (te instanceof TileReactorInjector) {
            RenderTileReactorComponent.renderInjector(ccrs, mat, getter, te.animRotationSpeed / 15.0f, packedLight, packedOverlay);
        }
        ccrs.reset();
    }

    public static void renderStabilizer(CCRenderState ccrs, Matrix4 mat, MultiBufferSource getter, float coreRotation, float brightness, int packedLight, int packedOverlay) {
        int i;
        float ringRotation = coreRotation * -0.5f;
        Matrix4 innerRotorMat = mat.copy();
        innerRotorMat.apply(new Rotation((double)coreRotation * 0.017453292519943, Vector3.Z_POS).at(new Vector3(0.0, 0.5, 0.0)));
        Matrix4 outerRotorMat = mat.copy();
        outerRotorMat.apply(new Rotation((double)coreRotation * 0.017453292519943 * -2.0, Vector3.Z_POS).at(new Vector3(0.0, 0.5, 0.0)));
        ccrs.bind(STAB_FRAME_TYPE, getter);
        modelStabFrame.render(ccrs, new IVertexOperation[]{mat});
        modelStabInnerRotorArm.render(ccrs, new IVertexOperation[]{innerRotorMat});
        modelStabOuterRotorArm.render(ccrs, new IVertexOperation[]{outerRotorMat});
        for (i = 0; i < 4; ++i) {
            ccrs.brightness = packedLight;
            Matrix4 ringMat = mat.copy();
            ringMat.apply(new Rotation((double)((float)(90 * i) + ringRotation) * 0.017453292519943, Vector3.Z_POS).at(new Vector3(0.0, 0.5, 0.0)));
            modelStabRing.render(ccrs, new IVertexOperation[]{ringMat});
            ccrs.brightness = (int)(brightness * 240.0f);
            Matrix4 emitterMat = ringMat.copy();
            emitterMat.apply(new Rotation(0.7853981633974351, Vector3.X_NEG).at(new Vector3(0.0, 0.9375, -0.59375)));
            modelStabRingEmitter.render(ccrs, new IVertexOperation[]{emitterMat});
        }
        ccrs.brightness = (int)(brightness * 240.0f);
        modelStabInnerRotor.render(ccrs, new IVertexOperation[]{innerRotorMat});
        modelStabOuterRotor.render(ccrs, new IVertexOperation[]{outerRotorMat});
        if (brightness >= 1.0f) {
            ccrs.bind(STAB_GLOW_TYPE, getter);
            modelStabInnerRotor.render(ccrs, new IVertexOperation[]{innerRotorMat});
            modelStabOuterRotor.render(ccrs, new IVertexOperation[]{outerRotorMat});
            for (i = 0; i < 4; ++i) {
                Matrix4 emitterMat = mat.copy();
                emitterMat.apply(new Rotation((double)((float)(90 * i) + ringRotation) * 0.017453292519943, Vector3.Z_POS).at(new Vector3(0.0, 0.5, 0.0)));
                emitterMat.apply(new Rotation(0.7853981633974351, Vector3.X_NEG).at(new Vector3(0.0, 0.9375, -0.59375)));
                modelStabRingEmitter.render(ccrs, new IVertexOperation[]{emitterMat});
            }
        }
    }

    public static void renderInjector(CCRenderState ccrs, Matrix4 mat, MultiBufferSource getter, float brightness, int packedLight, int packedOverlay) {
        ccrs.bind(INJECTOR_FRAME_TYPE, getter);
        modelInjectorBase.render(ccrs, new IVertexOperation[]{mat});
        ccrs.brightness = (int)(brightness * 240.0f);
        modelInjectorEmitters.render(ccrs, new IVertexOperation[]{mat});
        if (brightness >= 1.0f) {
            ccrs.bind(INJECTOR_GLOW_TYPE, getter);
            modelInjectorEmitters.render(ccrs, new IVertexOperation[]{mat});
        }
    }

    public static void renderComponent(Item item, CCRenderState ccrs, Matrix4 mat, MultiBufferSource getter, int packedLight, int packedOverlay) {
        if (item == DEContent.REACTOR_PRT_STAB_FRAME.get()) {
            ccrs.bind(STAB_FRAME_TYPE, getter);
            mat.translate(0.5, 0.0, 0.5);
            modelStabFrame.render(ccrs, new IVertexOperation[]{mat});
        } else if (item == DEContent.REACTOR_PRT_IN_ROTOR.get()) {
            ccrs.bind(STAB_FRAME_TYPE, getter);
            mat.translate(0.3, 0.0, 0.5);
            mat.scale(1.5, 1.5, 1.5);
            modelInnerRotorPart.render(ccrs, new IVertexOperation[]{mat});
        } else if (item == DEContent.REACTOR_PRT_OUT_ROTOR.get()) {
            ccrs.bind(STAB_FRAME_TYPE, getter);
            mat.translate(0.3, 0.0, 0.5);
            mat.scale(1.5, 1.5, 1.5);
            modelOuterRotorPart.render(ccrs, new IVertexOperation[]{mat});
        } else if (item == DEContent.REACTOR_PRT_ROTOR_FULL.get()) {
            ccrs.bind(STAB_FRAME_TYPE, getter);
            mat.translate(0.5, -0.2, 0.5);
            mat.scale(1.5, 1.5, 1.5);
            modelStabInnerRotor.render(ccrs, new IVertexOperation[]{mat});
            modelStabInnerRotorArm.render(ccrs, new IVertexOperation[]{mat});
            mat.apply(new Rotation(1.04719755119658, Vector3.Z_NEG).at(new Vector3(0.0, 0.5, 0.0)));
            modelStabOuterRotor.render(ccrs, new IVertexOperation[]{mat});
            modelStabOuterRotorArm.render(ccrs, new IVertexOperation[]{mat});
        } else if (item == DEContent.REACTOR_PRT_FOCUS_RING.get()) {
            ccrs.bind(STAB_FRAME_TYPE, getter);
            mat.translate(0.5, -0.2, 1.25);
            mat.scale(1.5, 1.5, 1.5);
            for (int i = 0; i < 4; ++i) {
                Matrix4 ringMat = mat.copy();
                ringMat.apply(new Rotation((double)(90 * i) * 0.017453292519943, Vector3.Z_POS).at(new Vector3(0.0, 0.5, 0.0)));
                modelStabRing.render(ccrs, new IVertexOperation[]{ringMat});
                Matrix4 emitterMat = ringMat.copy();
                emitterMat.apply(new Rotation(0.7853981633974351, Vector3.X_NEG).at(new Vector3(0.0, 0.9375, -0.59375)));
                modelStabRingEmitter.render(ccrs, new IVertexOperation[]{emitterMat});
            }
        }
    }

    static {
        Map map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/reactor/reactor_injector.obj")).quads().ignoreMtl().parse();
        modelInjectorBase = CCModel.combine((Collection)FastStream.of(map.entrySet()).filter(e -> !((String)e.getKey()).startsWith("emitter")).map(Map.Entry::getValue).toLinkedList()).backfacedCopy();
        modelInjectorEmitters = CCModel.combine((Collection)FastStream.of(map.entrySet()).filter(e -> ((String)e.getKey()).startsWith("emitter")).map(Map.Entry::getValue).toLinkedList()).backfacedCopy();
        Map stabMap = new OBJParser(new ResourceLocation("draconicevolution", "models/block/reactor/reactor_stabilizer.obj")).quads().ignoreMtl().parse();
        modelStabFrame = CCModel.combine((Collection)FastStream.of(stabMap.entrySet()).filter(e -> ((String)e.getKey()).startsWith("frame")).map(Map.Entry::getValue).toLinkedList()).backfacedCopy();
        modelStabInnerRotor = CCModel.combine((Collection)FastStream.of(stabMap.entrySet()).filter(e -> ((String)e.getKey()).startsWith("inner_rotor_blade")).map(Map.Entry::getValue).toLinkedList()).backfacedCopy();
        modelStabInnerRotorArm = CCModel.combine((Collection)FastStream.of(stabMap.entrySet()).filter(e -> ((String)e.getKey()).startsWith("inner_rotor_arm")).map(Map.Entry::getValue).toLinkedList()).backfacedCopy();
        modelStabOuterRotor = CCModel.combine((Collection)FastStream.of(stabMap.entrySet()).filter(e -> ((String)e.getKey()).startsWith("outer_rotor_blade")).map(Map.Entry::getValue).toLinkedList()).backfacedCopy();
        modelStabOuterRotorArm = CCModel.combine((Collection)FastStream.of(stabMap.entrySet()).filter(e -> ((String)e.getKey()).startsWith("outer_rotor_arm")).map(Map.Entry::getValue).toLinkedList()).backfacedCopy();
        modelStabRing = CCModel.combine((Collection)FastStream.of(stabMap.entrySet()).filter(e -> ((String)e.getKey()).startsWith("ring")).map(Map.Entry::getValue).toLinkedList()).backfacedCopy();
        modelStabRingEmitter = CCModel.combine((Collection)FastStream.of(stabMap.entrySet()).filter(e -> ((String)e.getKey()).startsWith("focus_panel")).map(Map.Entry::getValue).toLinkedList()).backfacedCopy();
        modelInnerRotorPart = CCModel.combine((Collection)FastStream.of(stabMap.entrySet()).filter(e -> ((String)e.getKey()).startsWith("inner_rotor_blade_a")).map(Map.Entry::getValue).toLinkedList()).backfacedCopy();
        modelOuterRotorPart = CCModel.combine((Collection)FastStream.of(stabMap.entrySet()).filter(e -> ((String)e.getKey()).startsWith("outer_rotor_blade_a")).map(Map.Entry::getValue).toLinkedList()).backfacedCopy();
    }
}

