/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import com.brandon3055.brandonscore.client.particle.IntParticleType;
import com.brandon3055.draconicevolution.client.render.particle.ParticleEnergyCoreFX;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class SparkParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    public float sparkSize = 0.5f;
    public float baseSize = 1.0f;

    public SparkParticle(ClientLevel level, double xPos, double yPos, double zPos, double xVel, double yVel, double zVel, SpriteSet spriteSet) {
        super(level, xPos, yPos, zPos);
        this.spriteSet = spriteSet;
        this.m_108337_(spriteSet.m_213979_(this.f_107223_));
        this.f_107215_ = (-0.5 + this.f_107223_.m_188500_()) * xVel;
        this.f_107216_ = (-0.5 + this.f_107223_.m_188500_()) * yVel;
        this.f_107217_ = (-0.5 + this.f_107223_.m_188500_()) * zVel;
        this.f_107225_ = 10 + level.f_46441_.m_188503_(10);
        this.f_107219_ = false;
    }

    public ParticleRenderType m_7556_() {
        return ParticleEnergyCoreFX.PARTICLE_NO_DEPTH_NO_LIGHT;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108337_(this.spriteSet.m_213979_(this.f_107223_));
        int ttd = this.f_107225_ - this.f_107224_;
        if (ttd < 10) {
            this.f_107663_ = (float)ttd / 10.0f * this.baseSize;
        }
        if (ttd <= 1) {
            this.f_107663_ = this.sparkSize;
        }
    }

    public static class Factory
    implements ParticleProvider<IntParticleType.IntParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet set) {
            this.spriteSet = set;
        }

        public Particle createParticle(IntParticleType.IntParticleData data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkParticle particle = new SparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            int params = data.get().length;
            if (params >= 3) {
                particle.m_107253_((float)data.get()[0] / 255.0f, (float)data.get()[1] / 255.0f, (float)data.get()[2] / 255.0f);
                params -= 3;
            }
            if (params >= 1) {
                particle.baseSize = (float)data.get()[3] / 1000.0f;
                particle.f_107663_ = particle.baseSize;
                --params;
            }
            if (params >= 1) {
                particle.sparkSize = (float)data.get()[4] / 1000.0f;
                --params;
            }
            if (params >= 1) {
                particle.f_107225_ = data.get()[5];
                --params;
            }
            if (params >= 1) {
                int max = data.get()[6];
                particle.f_107225_ += max > 0 ? level.f_46441_.m_188503_(max) : 0;
                --params;
            }
            if (params >= 1) {
                particle.f_107226_ = (float)data.get()[7] / 1000.0f;
                --params;
            }
            if (params >= 1) {
                particle.f_172258_ = (float)data.get()[8] / 1000.0f;
                --params;
            }
            if (params >= 1) {
                particle.m_172260_(xSpeed, ySpeed, zSpeed);
            }
            return particle;
        }
    }
}

