/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular.itemconfig;

import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiSlider;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.lib.BackgroundRender;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.SliderState;
import codechicken.lib.gui.modular.lib.geometry.Axis;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.ConfigurableItemGui;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class PropertyElement
extends GuiElement<PropertyElement> {
    protected PropertyData data;
    private boolean advanced;
    private ConfigurableItemGui gui;
    private GuiText label;
    private Supplier<Boolean> suppressToolTip = () -> false;
    private Supplier<Integer> opacitySupplier = () -> -16777216;
    private int index = 0;

    public PropertyElement(GuiParent<?> parent, PropertyData data, ConfigurableItemGui gui, int index, boolean advanced) {
        super(parent);
        this.data = data;
        this.gui = gui;
        this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)22.0));
        this.index = index;
        this.advanced = advanced;
        this.buildElement();
    }

    private void buildElement() {
        GuiSlider slider;
        Constraints.bind((ConstrainedGeometry)new GuiRectangle((GuiParent)this).fill(() -> (this.index % 2 == 0 ? (BCConfig.darkMode ? 0x101010 : 0x252525) : (BCConfig.darkMode ? 0x202020 : 0x404040)) | this.opacitySupplier.get()), (ConstrainedGeometry)this);
        this.label = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)this.data.displayName.m_6881_().m_130940_(ChatFormatting.GOLD)).setShadow(false).setEnableToolTip(() -> this.suppressToolTip.get() == false)).setTooltip(() -> this.data.toolTip != null ? Collections.singletonList(this.data.toolTip) : Collections.emptyList())).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)10.0))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)10.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-10.0));
        GuiButton valueButton = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)new GuiButton((GuiParent)this).setEnabled(() -> this.data.type == ConfigProperty.Type.BOOLEAN || this.data.type == ConfigProperty.Type.ENUM)).setPressSound(null).onPress(this::valueClicked).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)10.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)10.0));
        GuiButton decrement = ((GuiButton)ConfigurableItemGui.TOOLKIT.createIconButton((GuiParent)this, 10, 12, "dark/arrow_left").setEnabled(() -> this.data.type != ConfigProperty.Type.BOOLEAN)).onPress(() -> this.data.increment(-1));
        Constraints.placeInside((ConstrainedGeometry)decrement, (ConstrainedGeometry)this, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)1.0, (double)10.0);
        GuiButton increment = ((GuiButton)ConfigurableItemGui.TOOLKIT.createIconButton((GuiParent)this, 10, 12, "dark/arrow_right").setEnabled(() -> this.data.type != ConfigProperty.Type.BOOLEAN)).onPress(() -> this.data.increment(1));
        Constraints.placeInside((ConstrainedGeometry)increment, (ConstrainedGeometry)this, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)-1.0, (double)10.0);
        SliderBackground slideBg = (SliderBackground)((SliderBackground)((SliderBackground)((SliderBackground)((SliderBackground)new SliderBackground((GuiParent<?>)this).setEnabled(() -> this.data.type == ConfigProperty.Type.DECIMAL || this.data.type == ConfigProperty.Type.INTEGER)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)10.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)decrement.get(GeoParam.RIGHT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)increment.get(GeoParam.LEFT)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)10.0));
        slideBg.slider = slider = new GuiSlider((GuiParent)slideBg, Axis.X).setSliderState((SliderState)new DataSlideState(this.data));
        slider.getSlider().constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)6.0));
        Constraints.bind((ConstrainedGeometry)slider, (ConstrainedGeometry)slideBg, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
        Constraints.bind((ConstrainedGeometry)new GuiRectangle((GuiParent)slider.getSlider()).fill(() -> slider.isMouseOver() || slider.isDragging() ? -7274497 : -2039584), (ConstrainedGeometry)slider.getSlider());
        GuiText valueLabel = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)10.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)10.0));
        valueLabel.setTextSupplier(() -> Component.m_237113_((String)this.data.displayValue).m_130940_(valueLabel.isMouseOver() ? ChatFormatting.AQUA : ChatFormatting.DARK_AQUA));
        if (this.advanced && this.data.propUniqueName == null) {
            GuiButton globalButton = ((GuiButton)ConfigurableItemGui.TOOLKIT.createIconButton((GuiParent)this, 8, 8, () -> BCGuiTextures.get((String)(this.data.isGlobal ? "dark/global_icon" : "dark/global_icon_inactive"))).setTooltip(new Component[]{Component.m_237115_((String)"gui.draconicevolution.item_config.global.info")})).onPress(() -> this.data.toggleGlobal());
            Constraints.placeInside((ConstrainedGeometry)globalButton, (ConstrainedGeometry)this, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)1.0, (double)1.0);
            Constraints.bind((ConstrainedGeometry)new GuiRectangle((GuiParent)globalButton).shadedRect(-12545984, -4456517, 0).setEnabled(() -> this.data.isGlobal), (ConstrainedGeometry)globalButton, (double)-1.0);
        }
        Constraints.bind((ConstrainedGeometry)new GuiRectangle((GuiParent)this).border(() -> this.data.isGlobal ? -2130706688 : (this.gui.hoveredProvider.getProviderID().equals(this.data.providerID) ? -2147418368 : 0)).setEnabled(() -> this.advanced && this.gui.hoveredProvider != null && this.gui.hoveredProvider.getProviderName().equals(this.data.providerName)), (ConstrainedGeometry)this);
        Constraints.bind((ConstrainedGeometry)((GuiRectangle)new GuiRectangle((GuiParent)this).fill(-2130739072).setTooltip(new Component[]{Component.m_237115_((String)"gui.draconicevolution.item_config.provider_unavailable")})).setEnabled(() -> !this.data.isPropertyAvailable() && !this.data.isGlobal), (ConstrainedGeometry)this);
    }

    public void setSuppressToolTip(Supplier<Boolean> suppressToolTip) {
        this.suppressToolTip = suppressToolTip;
    }

    public void setOpacitySupplier(Supplier<Integer> opacitySupplier) {
        this.opacitySupplier = opacitySupplier;
    }

    public void tick(double mouseX, double mouseY) {
        super.tick(mouseX, mouseY);
        if (this.advanced && this.label.isMouseOver()) {
            this.gui.hoveredData = this.data;
        }
    }

    private void valueClicked() {
        if (this.data.type == ConfigProperty.Type.BOOLEAN) {
            this.data.toggleBooleanValue();
            this.mc().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        } else if (this.data.type == ConfigProperty.Type.ENUM && this.data.enumValueOptions.size() > 1) {
            int i = this.data.enumValueOptions.indexOf(this.data.enumValueIndex);
            if (++i >= this.data.enumValueOptions.size()) {
                i = 0;
            }
            this.data.updateEnumValue(this.data.enumValueOptions.get(i));
        }
    }

    private static class SliderBackground
    extends GuiElement<SliderBackground>
    implements BackgroundRender {
        private GuiSlider slider;

        public SliderBackground(@NotNull GuiParent<?> parent) {
            super(parent);
        }

        public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
            if (this.slider != null && (this.slider.isDragging() || this.slider.isMouseOver())) {
                render.rect(this.xMin(), this.yMin(), this.xSize(), this.ySize(), 1615289194);
            }
            render.rect(this.xMin(), this.yMin() + this.ySize() / 2.0 - 1.0, this.xSize(), 2.0, -8355712);
            render.rect(this.xMin(), this.yMin(), 1.0, this.ySize(), -8355712);
            render.rect(this.xMin() + this.xSize() - 1.0, this.yMin(), 1.0, this.ySize(), -8355712);
        }
    }

    private static class DataSlideState
    implements SliderState {
        private final PropertyData prop;

        public DataSlideState(PropertyData prop) {
            this.prop = prop;
        }

        public double getPos() {
            return MathHelper.map((double)(this.prop.type == ConfigProperty.Type.INTEGER ? (double)this.prop.integerValue : this.prop.decimalValue), (double)this.prop.minValue, (double)this.prop.maxValue, (double)0.0, (double)1.0);
        }

        public void setPos(double pos) {
            this.prop.updateNumberValue(MathHelper.map((double)pos, (double)0.0, (double)1.0, (double)this.prop.minValue, (double)this.prop.maxValue), true);
        }

        public double scrollSpeed() {
            return 0.05;
        }

        public boolean canScroll(Axis scrollAxis) {
            return Screen.m_96638_();
        }
    }
}

