/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class AtlasTextureHelper {
    private static final Map<ResourceLocation, Function<ResourceLocation, TextureAtlasSprite>> ATLAS_CACHE = new HashMap<ResourceLocation, Function<ResourceLocation, TextureAtlasSprite>>();
    public static TextureAtlasSprite[] ENERGY_PARTICLE = new TextureAtlasSprite[5];
    public static TextureAtlasSprite[] SPARK_PARTICLE = new TextureAtlasSprite[7];
    public static TextureAtlasSprite[] SPELL_PARTICLE = new TextureAtlasSprite[7];
    public static TextureAtlasSprite[] MIXED_PARTICLE;
    public static TextureAtlasSprite ORB_PARTICLE;
    public static TextureAtlasSprite PORTAL_PARTICLE;
    public static TextureAtlasSprite ENERGY_CORE_OVERLAY;
    public static ParticleRenderType PARTICLE_SHEET_TRANSLUCENT;

    public static void init(IEventBus modBus) {
        modBus.addListener(AtlasTextureHelper::textureStitch);
    }

    private static void textureStitch(TextureStitchEvent.Post event) {
        TextureAtlas atlas = event.getAtlas();
        if (atlas.m_118330_().equals((Object)TextureAtlas.f_118260_)) {
            int i;
            ATLAS_CACHE.clear();
            for (i = 0; i < ENERGY_PARTICLE.length; ++i) {
                AtlasTextureHelper.ENERGY_PARTICLE[i] = atlas.m_118316_(new ResourceLocation("draconicevolution", "energy_" + i));
            }
            for (i = 0; i < SPARK_PARTICLE.length; ++i) {
                AtlasTextureHelper.SPARK_PARTICLE[i] = atlas.m_118316_(new ResourceLocation("draconicevolution", "spark_" + i));
            }
            for (i = 0; i < SPELL_PARTICLE.length; ++i) {
                AtlasTextureHelper.SPELL_PARTICLE[i] = atlas.m_118316_(new ResourceLocation("draconicevolution", "spell_" + i));
            }
            MIXED_PARTICLE = (TextureAtlasSprite[])Stream.concat(Arrays.stream(SPARK_PARTICLE), Arrays.stream(SPELL_PARTICLE)).toArray(TextureAtlasSprite[]::new);
            ORB_PARTICLE = atlas.m_118316_(new ResourceLocation("draconicevolution", "white_orb"));
            PORTAL_PARTICLE = atlas.m_118316_(new ResourceLocation("draconicevolution", "portal"));
        }
        if (atlas.m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            ENERGY_CORE_OVERLAY = atlas.m_118316_(new ResourceLocation("draconicevolution", "block/energy_core/energy_core_overlay"));
        }
    }

    static {
        PARTICLE_SHEET_TRANSLUCENT = new ParticleRenderType(){

            public void m_6505_(BufferBuilder builder, TextureManager manager) {
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            }

            public void m_6294_(Tesselator tessellator) {
                tessellator.m_85914_();
            }

            public String toString() {
                return "TERRAIN_SHEET_TRANSLUCENT";
            }
        };
    }
}

