/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor.tileentity;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileReactorStabilizer
extends TileReactorComponent {
    public TileReactorStabilizer(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_REACTOR_STABILIZER.get(), pos, state);
        OPExtractor opExtractor = new OPExtractor(this);
        this.capManager.set(CapabilityOP.OP, (Object)opExtractor, new Direction[0]);
        this.capManager.setCapSideValidator((Object)opExtractor, face -> face == ((Direction)this.facing.get()).m_122424_());
    }

    @Override
    public void tick() {
        BlockEntity output;
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        TileReactorCore tile = this.getCachedCore();
        if (tile != null && tile.reactorState.get() == TileReactorCore.ReactorState.RUNNING && (output = this.f_58857_.m_7702_(this.f_58858_.m_121945_(((Direction)this.facing.get()).m_122424_()))) != null && EnergyUtils.canReceiveEnergy((BlockEntity)output, (Direction)((Direction)this.facing.get()))) {
            long sent = EnergyUtils.insertEnergy((BlockEntity)output, (long)tile.saturation.get(), (Direction)((Direction)this.facing.get()), (boolean)false);
            tile.saturation.subtract(sent);
        }
    }

    private class OPExtractor
    implements IOPStorage {
        private TileReactorStabilizer tile;

        public OPExtractor(TileReactorStabilizer tile) {
            this.tile = tile;
        }

        public long extractOP(long maxExtract, boolean simulate) {
            TileReactorCore core = TileReactorStabilizer.this.getCachedCore();
            if (core != null && core.reactorState.get() == TileReactorCore.ReactorState.RUNNING) {
                long subtracted = Math.min(core.saturation.get(), maxExtract);
                if (!simulate) {
                    core.saturation.subtract(subtracted);
                }
                return subtracted;
            }
            return 0L;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return (int)this.extractOP(maxExtract, simulate);
        }

        public long getMaxOPStored() {
            return Long.MAX_VALUE;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return Integer.MAX_VALUE;
        }

        public long modifyEnergyStored(long amount) {
            return 0L;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return false;
        }
    }
}

