/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleHelper;
import com.brandon3055.draconicevolution.api.modules.data.TreeHarvestData;
import com.brandon3055.draconicevolution.api.modules.entities.logic.ForestHarvestHandler;
import com.brandon3055.draconicevolution.api.modules.entities.logic.IHarvestHandler;
import com.brandon3055.draconicevolution.api.modules.entities.logic.TreeHarvestHandler;
import com.brandon3055.draconicevolution.api.modules.lib.EntityOverridesItemUse;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

public class TreeHarvestEntity
extends ModuleEntity<TreeHarvestData>
implements EntityOverridesItemUse {
    private IHarvestHandler activeHandler = null;
    private InventoryDynamic itemBuffer = new InventoryDynamic();
    private BooleanProperty harvestLeaves = new BooleanProperty("tree_harvest_mod.leaves", true).setFormatter(ConfigProperty.BooleanFormatter.YES_NO);
    private IntegerProperty harvestRange;

    public TreeHarvestEntity(Module<TreeHarvestData> module) {
        super(module);
        this.addProperty(this.harvestLeaves);
        this.harvestRange = new IntegerProperty("tree_harvest_mod.range", module.getData().range()).setFormatter(ConfigProperty.IntegerFormatter.RAW).range(0, module.getData().range());
        this.addProperty(this.harvestRange);
    }

    private void useTick(LivingEntityUseItemEvent.Tick event) {
        LivingEntity livingEntity;
        if (this.activeHandler == null || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ItemStack stack = event.getItem();
        LazyOptional optional = stack.getCapability(DECapabilities.OP_STORAGE);
        if (!optional.isPresent()) {
            return;
        }
        IOPStorage storage = (IOPStorage)optional.orElseThrow(IllegalStateException::new);
        this.activeHandler.tick(player.m_9236_(), player, stack, storage, this.itemBuffer);
        if (this.itemBuffer.getStacks().size() > 8) {
            this.dropContents((Entity)player, stack);
        }
    }

    private void endUse(LivingEntityUseItemEvent event) {
        LivingEntity livingEntity;
        if (this.activeHandler != null && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            this.activeHandler.stop(player.m_9236_(), player);
        }
        this.activeHandler = null;
        this.dropContents((Entity)event.getEntity(), event.getItem());
    }

    private void dropContents(Entity entity, ItemStack stack) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!this.itemBuffer.m_7983_()) {
                ModuleHelper.handleItemCollection((Player)serverPlayer, this.host, EnergyUtils.getStorage((ItemStack)stack), this.itemBuffer);
                this.itemBuffer.m_6211_();
            }
        }
    }

    @Override
    public void onEntityUseItem(LivingEntityUseItemEvent useEvent) {
        if (useEvent.isCanceled()) {
            return;
        }
        if (useEvent instanceof LivingEntityUseItemEvent.Start) {
            LivingEntityUseItemEvent.Start event = (LivingEntityUseItemEvent.Start)useEvent;
            event.setDuration(72000);
        } else if (useEvent instanceof LivingEntityUseItemEvent.Tick) {
            LivingEntityUseItemEvent.Tick event = (LivingEntityUseItemEvent.Tick)useEvent;
            this.useTick(event);
        } else if (useEvent instanceof LivingEntityUseItemEvent.Stop || useEvent instanceof LivingEntityUseItemEvent.Finish) {
            this.endUse(useEvent);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onPlayerInteractEvent(PlayerInteractEvent playerEvent) {
        if (playerEvent.isCanceled()) {
            return;
        }
        data = (TreeHarvestData)this.getModule().getData();
        if (!(playerEvent instanceof PlayerInteractEvent.RightClickItem)) ** GOTO lbl-1000
        event = (PlayerInteractEvent.RightClickItem)playerEvent;
        if (this.activeHandler == null) {
            if (data.range() <= 0) {
                return;
            }
            var6_4 = event.getEntity();
            if (var6_4 instanceof ServerPlayer) {
                player = (ServerPlayer)var6_4;
                this.activeHandler = new ForestHarvestHandler(data.speed(), this.harvestRange.getValue(), this.harvestLeaves.getValue());
                this.activeHandler.start(event.getPos(), event.getLevel(), player);
            }
        } else if (playerEvent instanceof PlayerInteractEvent.RightClickBlock) {
            event = (PlayerInteractEvent.RightClickBlock)playerEvent;
            var6_5 = event.getEntity();
            if (var6_5 instanceof ServerPlayer) {
                player = (ServerPlayer)var6_5;
                this.activeHandler = new TreeHarvestHandler(data.speed(), event.getHitVec().m_82434_(), this.harvestLeaves.getValue());
                this.activeHandler.start(event.getPos(), event.getLevel(), player);
            }
        } else {
            return;
        }
        playerEvent.setCanceled(true);
        playerEvent.getEntity().m_6672_(playerEvent.getHand());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addHostHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"module.draconicevolution.tree_harvest.single").m_130940_(ChatFormatting.DARK_GRAY));
            if (((TreeHarvestData)this.getModule().getData()).range() > 0) {
                tooltip.add((Component)Component.m_237115_((String)"module.draconicevolution.tree_harvest.area").m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void modifyFirstPersonUsingPose(RenderHandEvent event, boolean leftHand) {
        PoseStack poseStack = event.getPoseStack();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int handOffset = !leftHand ? 1 : -1;
        poseStack.m_252880_((float)handOffset * -0.2785682f, 0.18344387f, 0.15731531f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-13.935f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)handOffset * 35.3f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)handOffset * -9.785f));
        float drawTime = 72000.0f - ((float)player.m_21212_() - event.getPartialTick() + 1.0f);
        float charge = drawTime / 20.0f;
        charge = (charge * charge + charge * 2.0f) / 3.0f;
        if (charge > 1.0f) {
            charge = 1.0f;
        }
        if (charge > 0.1f) {
            float f15 = Mth.m_14031_((float)((drawTime - 0.1f) * 1.3f));
            float f18 = charge - 0.1f;
            float animOffset = f15 * f18;
            poseStack.m_252880_(animOffset * 0.0f, animOffset * 0.004f, animOffset * 0.0f);
        }
        poseStack.m_252880_(charge * 0.0f, charge * 0.0f, charge * 0.04f);
        poseStack.m_85841_(1.0f, 1.0f, 1.0f + charge * 0.2f);
        poseStack.m_252781_(Axis.f_252392_.m_252977_((float)handOffset * 45.0f));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void modifyPlayerModelPose(Player player, PlayerModel<?> model, boolean leftHand) {
        if (!leftHand) {
            model.f_102811_.f_104204_ = -0.1f + model.f_102808_.f_104204_;
            model.f_102812_.f_104204_ = 0.1f + model.f_102808_.f_104204_ + 0.4f;
            model.f_102811_.f_104203_ = -1.5707964f + model.f_102808_.f_104203_;
            model.f_102812_.f_104203_ = -1.5707964f + model.f_102808_.f_104203_;
        } else {
            model.f_102811_.f_104204_ = -0.1f + model.f_102808_.f_104204_ - 0.4f;
            model.f_102812_.f_104204_ = 0.1f + model.f_102808_.f_104204_;
            model.f_102811_.f_104203_ = -1.5707964f + model.f_102808_.f_104203_;
            model.f_102812_.f_104203_ = -1.5707964f + model.f_102808_.f_104203_;
        }
        model.f_103376_.m_104315_(model.f_102814_);
        model.f_103377_.m_104315_(model.f_102813_);
        model.f_103374_.m_104315_(model.f_102812_);
        model.f_103375_.m_104315_(model.f_102811_);
        model.f_103378_.m_104315_(model.f_102810_);
    }

    @Override
    protected CompoundTag writeExtraData(CompoundTag nbt) {
        this.itemBuffer.writeToNBT(nbt);
        return super.writeExtraData(nbt);
    }

    @Override
    protected void readExtraData(CompoundTag nbt) {
        this.itemBuffer.readFromNBT(nbt);
        super.readExtraData(nbt);
    }
}

