/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_creo.client.render;

import com.hollingsworth.ars_creo.common.block.StarbuncleWheelBlock;
import com.hollingsworth.ars_creo.common.block.StarbuncleWheelTile;
import com.hollingsworth.ars_creo.common.registry.ModBlockRegistry;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;

public class CarbuncleWheelModel
extends GeoModel<StarbuncleWheelTile> {
    static final ResourceLocation model = new ResourceLocation("ars_creo", "geo/starbuncle_wheel.geo.json");
    static final ResourceLocation texture = new ResourceLocation("ars_creo", "textures/block/starbuncle_wheel.png");
    static final ResourceLocation animations = new ResourceLocation("ars_creo", "animations/starbuncle_wheel_animation.json");

    public void setCustomAnimations(StarbuncleWheelTile entity, long uniqueID, AnimationState<StarbuncleWheelTile> customPredicate) {
        super.setCustomAnimations((GeoAnimatable)entity, uniqueID, customPredicate);
        CoreGeoBone head = this.getAnimationProcessor().getBone("wheel");
        Direction facing = (Direction)entity.m_58900_().m_61143_((Property)StarbuncleWheelBlock.FACING);
        float angle = CarbuncleWheelModel.getAngleForTe((KineticBlockEntity)entity, entity.m_58899_(), ((StarbuncleWheelBlock)((Object)ModBlockRegistry.STARBY_WHEEL.get())).getRotationAxis(entity.m_58900_()));
        if (facing == Direction.SOUTH || facing == Direction.EAST) {
            angle = -angle;
        }
        head.setRotY(angle);
    }

    public static float getAngleForTe(KineticBlockEntity te, BlockPos pos, Direction.Axis axis) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)te.m_58904_());
        float offset = CarbuncleWheelModel.getRotationOffsetForPosition(te, pos, axis);
        return (time * te.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
    }

    protected static float getRotationOffsetForPosition(KineticBlockEntity te, BlockPos pos, Direction.Axis axis) {
        float offset = ICogWheel.isLargeCog((BlockState)te.m_58900_()) ? 11.25f : 0.0f;
        double d = ((axis == Direction.Axis.X ? 0 : pos.m_123341_()) + (axis == Direction.Axis.Y ? 0 : pos.m_123342_()) + (axis == Direction.Axis.Z ? 0 : pos.m_123343_())) % 2;
        if (d == 0.0) {
            offset = 22.5f;
        }
        return offset;
    }

    public ResourceLocation getModelResource(StarbuncleWheelTile object) {
        return model;
    }

    public ResourceLocation getTextureResource(StarbuncleWheelTile object) {
        return texture;
    }

    public ResourceLocation getAnimationResource(StarbuncleWheelTile animatable) {
        return animations;
    }
}

