/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.inventory;

import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.computer.menu.ServerInputState;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractComputerMenu
extends AbstractContainerMenu
implements ComputerMenu {
    public static final int SIDEBAR_WIDTH = 17;
    private final int uploadMaxSize;
    private final Predicate<Player> canUse;
    private final ComputerFamily family;
    private final ContainerData data;
    @Nullable
    private final ServerComputer computer;
    @Nullable
    private final ServerInputState<AbstractComputerMenu> input;
    @Nullable
    private final NetworkedTerminal terminal;
    private final ItemStack displayStack;

    public AbstractComputerMenu(MenuType<? extends AbstractComputerMenu> type, int id, Predicate<Player> canUse, ComputerFamily family, @Nullable ServerComputer computer, @Nullable ComputerContainerData containerData) {
        super(type, id);
        this.canUse = canUse;
        this.family = family;
        this.data = computer == null ? new SimpleContainerData(1) : () -> computer.isOn() ? 1 : 0;
        this.m_38884_(this.data);
        this.computer = computer;
        this.input = computer == null ? null : new ServerInputState<AbstractComputerMenu>(this);
        this.terminal = containerData == null ? null : containerData.terminal().create();
        this.displayStack = containerData == null ? ItemStack.f_41583_ : containerData.displayStack();
        this.uploadMaxSize = containerData == null ? Config.uploadMaxSize : containerData.uploadMaxSize();
    }

    public boolean m_6875_(Player player) {
        return (this.computer == null || this.computer.checkUsable(player)) && this.canUse.test(player);
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public boolean isOn() {
        return this.data.m_6413_(0) != 0;
    }

    public int getUploadMaxSize() {
        return this.uploadMaxSize;
    }

    @Override
    public ServerComputer getComputer() {
        if (this.computer == null) {
            throw new UnsupportedOperationException("Cannot access server computer on the client");
        }
        return this.computer;
    }

    @Override
    public ServerInputHandler getInput() {
        if (this.input == null) {
            throw new UnsupportedOperationException("Cannot access server computer on the client");
        }
        return this.input;
    }

    @Override
    public void updateTerminal(TerminalState state) {
        if (this.terminal == null) {
            throw new UnsupportedOperationException("Cannot update terminal on the server");
        }
        state.apply(this.terminal);
    }

    public Terminal getTerminal() {
        if (this.terminal == null) {
            throw new IllegalStateException("Cannot update terminal on the server");
        }
        return this.terminal;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (this.input != null) {
            this.input.close();
        }
    }

    public ItemStack getDisplayStack() {
        return this.displayStack;
    }
}

