/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.client.render.highlight;

import com.glodblock.github.glodium.client.render.ColorData;
import com.glodblock.github.glodium.client.render.highlight.HighlightHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.OptionalDouble;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

public class HighlightRender
extends RenderType {
    public static final HighlightRender INSTANCE = new HighlightRender();
    private final RenderStateShard.LineStateShard LINE_3 = new RenderStateShard.LineStateShard(OptionalDouble.of(3.0));
    private final RenderType BLOCK_HIGHLIGHT_LINE = HighlightRender.m_173215_((String)"glodium_block_highlight_line", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)65536, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110673_(this.LINE_3).m_110685_(RenderStateShard.TransparencyStateShard.f_110137_).m_173290_(f_110147_).m_110663_(f_110111_).m_110661_(f_110110_).m_110671_(f_110153_).m_110687_(f_110114_).m_173292_(f_173095_).m_110691_(false));

    public static void hook(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            INSTANCE.tick(event.getPoseStack(), Minecraft.m_91087_().m_91269_().m_110104_(), event.getCamera());
        }
    }

    public void tick(PoseStack stack, MultiBufferSource.BufferSource multiBuf, Camera camera) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        this.invalidate();
        Collection<HighlightHandler.HighlightData> drawList = HighlightHandler.getBlockData();
        if (drawList.isEmpty()) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        for (HighlightHandler.HighlightData block : drawList) {
            if (!block.checkDim((ResourceKey<Level>)world.m_46472_()) || !block.allowRender()) continue;
            this.drawBlockOutline(block.box(), block.color(), stack, camera, (MultiBufferSource)multiBuf);
        }
        multiBuf.m_109911_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    private void invalidate() {
        while (HighlightHandler.getFirst() != null) {
            HighlightHandler.HighlightData info = HighlightHandler.getFirst();
            if (System.currentTimeMillis() <= info.time()) break;
            HighlightHandler.expire();
        }
    }

    private void drawBlockOutline(AABB box, ColorData color, PoseStack stack, Camera camera, MultiBufferSource multiBuf) {
        float r = color.getRf();
        float g = color.getGf();
        float b = color.getBf();
        float a = color.getAf();
        if (camera.m_90593_()) {
            Vec3 vec3 = camera.m_90583_().m_82548_();
            AABB aabb = box.m_82383_(vec3);
            Vec3 topRight = new Vec3(aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
            Vec3 bottomRight = new Vec3(aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
            Vec3 bottomLeft = new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82293_);
            Vec3 topLeft = new Vec3(aabb.f_82288_, aabb.f_82292_, aabb.f_82293_);
            Vec3 topRight2 = new Vec3(aabb.f_82291_, aabb.f_82292_, aabb.f_82290_);
            Vec3 bottomRight2 = new Vec3(aabb.f_82291_, aabb.f_82289_, aabb.f_82290_);
            Vec3 bottomLeft2 = new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_);
            Vec3 topLeft2 = new Vec3(aabb.f_82288_, aabb.f_82292_, aabb.f_82290_);
            VertexConsumer buf = multiBuf.m_6299_(this.BLOCK_HIGHLIGHT_LINE);
            this.renderBox(buf, stack, topLeft, bottomLeft, topRight, bottomRight, r, g, b, a);
            this.renderBox(buf, stack, topLeft2, bottomLeft2, topRight2, bottomRight2, r, g, b, a);
            this.renderLine(buf, stack, topRight, topRight2, r, g, b, a);
            this.renderLine(buf, stack, bottomRight, bottomRight2, r, g, b, a);
            this.renderLine(buf, stack, bottomLeft, bottomLeft2, r, g, b, a);
            this.renderLine(buf, stack, topLeft, topLeft2, r, g, b, a);
        }
    }

    private void renderBox(VertexConsumer buf, PoseStack stack, Vec3 topLeft, Vec3 bottomLeft, Vec3 topRight, Vec3 bottomRight, float r, float g, float b, float a) {
        this.renderLine(buf, stack, topLeft, bottomLeft, r, g, b, a);
        this.renderLine(buf, stack, topLeft, topRight, r, g, b, a);
        this.renderLine(buf, stack, bottomRight, bottomLeft, r, g, b, a);
        this.renderLine(buf, stack, bottomRight, topRight, r, g, b, a);
    }

    private void renderLine(VertexConsumer buf, PoseStack pose, Vec3 from, Vec3 to, float r, float g, float b, float a) {
        Matrix4f mat = pose.m_85850_().m_252922_();
        Vec3 normal = from.m_82546_(to);
        buf.m_252986_(mat, (float)from.f_82479_, (float)from.f_82480_, (float)from.f_82481_).m_85950_(r, g, b, a).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        buf.m_252986_(mat, (float)to.f_82479_, (float)to.f_82480_, (float)to.f_82481_).m_85950_(r, g, b, a).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }

    private HighlightRender() {
        super("", DefaultVertexFormat.f_166851_, VertexFormat.Mode.LINES, 0, false, false, () -> {}, () -> {});
    }
}

