/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import cofh.lib.util.helpers.StringHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class DeferredRegisterCoFH<T> {
    private final String modid;
    private final DeferredRegister<T> wrappedRegister;
    private final Map<ResourceLocation, RegistryObject<T>> registryObjects = new HashMap<ResourceLocation, RegistryObject<T>>();

    private DeferredRegisterCoFH(DeferredRegister<T> wrappedRegister, String modid) {
        this.modid = modid;
        this.wrappedRegister = wrappedRegister;
    }

    public static <B> DeferredRegisterCoFH<B> create(ResourceLocation registryName, String modid) {
        return new DeferredRegisterCoFH(DeferredRegister.create((ResourceLocation)registryName, (String)modid), modid);
    }

    public static <B> DeferredRegisterCoFH<B> create(IForgeRegistry<B> reg, String modid) {
        return new DeferredRegisterCoFH(DeferredRegister.create(reg, (String)modid), modid);
    }

    public static <B> DeferredRegisterCoFH<B> create(ResourceKey<? extends Registry<B>> key, String modid) {
        return new DeferredRegisterCoFH(DeferredRegister.create(key, (String)modid), modid);
    }

    public static <B> DeferredRegisterCoFH<B> createOptional(ResourceKey<? extends Registry<B>> key, String modid) {
        return new DeferredRegisterCoFH(DeferredRegister.createOptional(key, (String)modid), modid);
    }

    public static <B> DeferredRegisterCoFH<B> createOptional(ResourceLocation registryName, String modid) {
        return new DeferredRegisterCoFH(DeferredRegister.create((ResourceLocation)registryName, (String)modid), modid);
    }

    public synchronized <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> sup) {
        RegistryObject ret = this.wrappedRegister.register(name, sup);
        this.registryObjects.put(ret.getId(), ret);
        return ret;
    }

    public Supplier<IForgeRegistry<T>> makeRegistry(Supplier<RegistryBuilder<T>> sup) {
        return this.wrappedRegister.makeRegistry(sup);
    }

    public void register(IEventBus bus) {
        this.wrappedRegister.register(bus);
    }

    public T get(String resourceLoc) {
        return this.get(StringHelper.decompose(this.modid, resourceLoc, ':'));
    }

    private T get(String[] resourceLoc) {
        return this.get(resourceLoc[0], resourceLoc[1]);
    }

    public T get(String modid, String name) {
        return this.get(new ResourceLocation(modid, name));
    }

    public T get(ResourceLocation resourceLoc) {
        RegistryObject<T> reg = this.registryObjects.get(resourceLoc);
        return (T)(reg == null ? null : reg.get());
    }

    public RegistryObject<T> getSup(String resourceLoc) {
        return this.getSup(StringHelper.decompose(this.modid, resourceLoc, ':'));
    }

    private RegistryObject<T> getSup(String[] resourceLoc) {
        return this.getSup(resourceLoc[0], resourceLoc[1]);
    }

    public RegistryObject<T> getSup(String modid, String name) {
        return this.getSup(new ResourceLocation(modid, name));
    }

    @Nullable
    public RegistryObject<T> getSup(ResourceLocation resourceLoc) {
        return this.registryObjects.get(resourceLoc);
    }
}

