/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.trash;

import alexthw.starbunclemania.starbuncle.trash.StarbyVoidBehavior;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;

public class SnatchItem
extends Goal {
    protected Starbuncle starbuncle;
    boolean itemStuck;
    int timeFinding;
    int stuckTicks;
    List<ItemEntity> destList = new ArrayList<ItemEntity>();
    ItemEntity dest;
    public StarbyVoidBehavior behavior;
    private final Predicate<ItemEntity> TRUSTED_TARGET_SELECTOR = itemEntity -> !itemEntity.m_32063_() && itemEntity.m_6084_();

    public SnatchItem(Starbuncle starbuncle, StarbyVoidBehavior behavior) {
        this.starbuncle = starbuncle;
        this.behavior = behavior;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public void m_8041_() {
        super.m_8041_();
        this.itemStuck = false;
        this.timeFinding = 0;
        this.destList = new ArrayList<ItemEntity>();
        this.dest = null;
        this.stuckTicks = 0;
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.NONE;
    }

    public void m_8056_() {
        super.m_8056_();
        this.timeFinding = 0;
        this.itemStuck = false;
        this.stuckTicks = 0;
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.HUNTING_ITEM;
    }

    public List<ItemEntity> nearbyItems() {
        return this.starbuncle.m_9236_().m_6443_(ItemEntity.class, this.starbuncle.getAABB(), this.TRUSTED_TARGET_SELECTOR);
    }

    public boolean m_8045_() {
        if (this.timeFinding > 300) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("TooLong", "Stopped finding item, time finding expired"));
            return false;
        }
        return !this.itemStuck && this.starbuncle.getHeldStack().m_41619_();
    }

    public boolean m_8036_() {
        if (!this.starbuncle.getHeldStack().m_41619_()) {
            this.starbuncle.setHeldStack(ItemStack.f_41583_);
        }
        ItemStack itemstack = this.starbuncle.getHeldStack();
        List<ItemEntity> list = this.nearbyItems();
        this.itemStuck = false;
        this.destList = new ArrayList<ItemEntity>();
        if (itemstack.m_41619_() && !list.isEmpty()) {
            for (ItemEntity entity : list) {
                if (this.behavior.getValidStorePos(entity.m_32055_()) == null) continue;
                this.destList.add(entity);
            }
        }
        if (this.destList.isEmpty()) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoStacks", "No storable items nearby"));
            return false;
        }
        Collections.shuffle(this.destList);
        for (ItemEntity e : this.destList) {
            Path path = this.starbuncle.minecraftPathNav.m_148218_(BlockPos.m_274446_((Position)e.m_20182_()), 1, 9);
            if (path == null || !path.m_77403_()) continue;
            this.dest = e;
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("DestSet", "Dest set to " + e));
            break;
        }
        if (this.dest == null) {
            this.starbuncle.setBackOff(30 + this.starbuncle.m_9236_().f_46441_.m_188503_(30));
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NotReachable", "No pathable items nearby"));
            return false;
        }
        if (this.behavior.isBedPowered()) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("BedPowered", "Bed powered, cannot pickup items"));
            return false;
        }
        return this.dest != null && !this.nearbyItems().isEmpty();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.dest == null || this.dest.m_32055_().m_41619_() || this.dest.m_213877_()) {
            this.itemStuck = true;
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("ItemRemoved", "Item removed during goal"));
            return;
        }
        ++this.timeFinding;
        this.starbuncle.minecraftPathNav.m_26573_();
        Path path = this.starbuncle.minecraftPathNav.m_148218_(BlockPos.m_274446_((Position)this.dest.m_20182_()), 1, 9);
        if (path == null || !path.m_77403_()) {
            ++this.stuckTicks;
            if (this.stuckTicks > 100) {
                this.itemStuck = true;
                this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("ItemStuck", "Item stuck for 5 seconds. Ending goal"));
            }
            return;
        }
        ItemStack itemstack = this.starbuncle.getHeldStack();
        if (!itemstack.m_41619_()) {
            this.itemStuck = true;
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("ItemPickup", "Received item, ending."));
            return;
        }
        this.starbuncle.getNavigation().m_5624_((Entity)this.dest, 1.4);
        this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("PathTo", "Pathing to " + this.dest));
    }
}

