/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.energy;

import alexthw.starbunclemania.Configs;
import alexthw.starbunclemania.starbuncle.energy.StarbyEnergyBehavior;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyExtractGoal
extends GoToPosGoal<StarbyEnergyBehavior> {
    public EnergyExtractGoal(Starbuncle entity, StarbyEnergyBehavior energyBehavior) {
        super(entity, (StarbyBehavior)energyBehavior, () -> energyBehavior.getEnergy() <= (Integer)Configs.STARBATTERY_THRESHOLD.get());
    }

    public boolean m_8036_() {
        boolean superCan = super.m_8036_();
        if (!superCan || ((StarbyEnergyBehavior)this.behavior).FROM_LIST.isEmpty()) {
            return false;
        }
        if (this.getDestination() == null) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoTakeDestination", "No valid take destination"));
            this.starbuncle.setBackOff(5 + this.starbuncle.m_9236_().f_46441_.m_188503_(20));
            return false;
        }
        if (((StarbyEnergyBehavior)this.behavior).isBedPowered()) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("BedPowered", "Bed Powered, cannot take"));
            return false;
        }
        return true;
    }

    public void m_8056_() {
        super.m_8056_();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.TAKING_ITEM;
    }

    @Nullable
    public BlockPos getDestination() {
        return ((StarbyEnergyBehavior)this.behavior).getBatteryForTake();
    }

    public boolean onDestinationReached() {
        BlockPos pos = ((StarbyEnergyBehavior)this.behavior).getBatteryForStore();
        if (pos == null) {
            return true;
        }
        IEnergyStorage take = ((StarbyEnergyBehavior)this.behavior).getHandlerFromCap(this.targetPos, (Direction)((StarbyEnergyBehavior)this.behavior).FROM_DIRECTION_MAP.get(this.targetPos.hashCode()));
        IEnergyStorage storage = ((StarbyEnergyBehavior)this.behavior).getHandlerFromCap(pos, (Direction)((StarbyEnergyBehavior)this.behavior).TO_DIRECTION_MAP.get(pos.hashCode()));
        if (take != null && storage != null) {
            int takeAmount = ((StarbyEnergyBehavior)this.behavior).getRatio();
            this.starbuncle.m_9236_().m_5594_(null, this.targetPos, SoundEvents.f_11691_, SoundSource.NEUTRAL, 0.15f, 2.0f);
            int actualTake = take.extractEnergy(takeAmount, false);
            ((StarbyEnergyBehavior)this.behavior).setEnergy(((StarbyEnergyBehavior)this.behavior).getEnergy() + actualTake);
        }
        return true;
    }
}

