/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.jei;

import alexthw.starbunclemania.jei.StarPlugin;
import alexthw.starbunclemania.recipe.FluidSourcelinkRecipe;
import alexthw.starbunclemania.registry.ModRegistry;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class FluidLinkRecipeCategory
implements IRecipeCategory<FluidSourcelinkRecipe> {
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;
    public IDrawable background;
    public IDrawable icon;
    static final ResourceLocation ARROW = new ResourceLocation("jei", "textures/jei/gui/gui_vanilla.png");

    public FluidLinkRecipeCategory(final IGuiHelper helper) {
        this.background = helper.createBlankDrawable(120, 32);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Block)ModRegistry.FLUID_SOURCELINK.get()).m_5456_().m_7968_());
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            @NotNull
            public IDrawableAnimated load(@NotNull Integer cookTime) {
                return helper.drawableBuilder(ARROW, 82, 128, 24, 32).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    @NotNull
    public RecipeType<FluidSourcelinkRecipe> getRecipeType() {
        return StarPlugin.FLUID_SOURCELINK;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237113_((String)"Fluid Sourcelink conversion");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, FluidSourcelinkRecipe recipe, @NotNull IFocusGroup focuses) {
        ResourceLocation fluid_name = recipe.getFluidType();
        try {
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getDelegateOrThrow(fluid_name).get();
            builder.addSlot(RecipeIngredientRole.INPUT, 6, 5).setFluidRenderer(1000L, false, 16, 24).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)new FluidStack(fluid, 1000));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void draw(FluidSourcelinkRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        IDrawableAnimated arrow = (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)40);
        arrow.draw(guiGraphics, 25, 10);
        Font font = Minecraft.m_91087_().f_91062_;
        double ratio = recipe.getConversion_ratio() * 1000.0;
        guiGraphics.m_280056_(font, String.format("%.0f Source", ratio), 55, 12, 0, false);
    }
}

