/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.datagen;

import alexthw.starbunclemania.StarbuncleMania;
import alexthw.starbunclemania.registry.ModRegistry;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class StarItemModelProvider
extends ItemModelProvider {
    private static final ResourceLocation GENERATED = new ResourceLocation("item/generated");

    public StarItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "starbunclemania", existingFileHelper);
    }

    protected void registerModels() {
        this.directionScroll();
        this.generatedItem(ModRegistry.FLUID_SCROLL_D);
        this.generatedItem(ModRegistry.FLUID_SCROLL_A);
    }

    private void directionScroll() {
        String path = ModRegistry.DIRECTION_SCROLL.getId().m_135815_();
        ((ItemModelBuilder)this.withExistingParent(path, GENERATED)).texture("layer0", this.modLoc("item/blank_parchment"));
        ItemModelBuilder builder = (ItemModelBuilder)this.getBuilder(path);
        for (Direction side : Direction.values()) {
            builder.override().predicate(StarbuncleMania.prefix("side"), (float)side.ordinal()).model((ModelFile)this.singleTexture("item/ds/" + path + "_" + side.ordinal(), GENERATED, "layer0", this.modLoc("item/ds/" + path + "_" + side))).end();
        }
    }

    private void generatedItem(RegistryObject<Item> i) {
        String name = i.getId().m_135815_();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", StarbuncleMania.prefix("item/" + name));
    }

    private void blockGeneratedItem(RegistryObject<Item> i) {
        String name = i.getId().m_135815_();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", StarbuncleMania.prefix("block/" + name));
    }

    private void blockItem(RegistryObject<Item> i) {
        String name = i.getId().m_135815_();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(StarbuncleMania.prefix("block/" + name)));
    }
}

