/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common.item.cosmetic;

import alexthw.starbunclemania.client.BalloonRenderer;
import alexthw.starbunclemania.starbuncle.gas.StarbyGasBehavior;
import com.hollingsworth.arsnouveau.api.entity.ChangeableBehavior;
import com.hollingsworth.arsnouveau.api.entity.IDecoratable;
import com.hollingsworth.arsnouveau.api.item.ICosmeticItem;
import com.hollingsworth.arsnouveau.common.crafting.recipes.IDyeable;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarStarbuncle;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class StarBalloon
extends Item
implements ICosmeticItem,
GeoItem,
IDyeable {
    static final Vec3 Translation = new Vec3(-0.1, 0.0, -0.05);
    static final Vec3 Scaling = new Vec3(1.0, 1.0, 1.0);
    public final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public StarBalloon(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack pStack, @NotNull Player pPlayer, @NotNull LivingEntity pInteractionTarget, @NotNull InteractionHand pUsedHand) {
        if (pInteractionTarget instanceof IDecoratable) {
            IDecoratable starbuncle = (IDecoratable)pInteractionTarget;
            if (this.canWear(pInteractionTarget)) {
                starbuncle.setCosmeticItem(pStack.m_41620_(1));
                if (pInteractionTarget instanceof Starbuncle) {
                    Starbuncle starby = (Starbuncle)pInteractionTarget;
                    if (!pPlayer.m_6144_() && ModList.get().isLoaded("mekanism")) {
                        starby.setBehavior((ChangeableBehavior)new StarbyGasBehavior(starby, new CompoundTag()));
                        PortUtil.sendMessage((Entity)pPlayer, (Component)Component.m_237115_((String)"ars_nouveau.starbuncle.gas_behavior_set"));
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6880_(pStack, pPlayer, pInteractionTarget, pUsedHand);
    }

    public void onDye(ItemStack stack, DyeColor dyeColor) {
        stack.m_41784_().m_128405_("color", dyeColor.m_41070_());
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            final BalloonRenderer renderer = new BalloonRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public Vec3 getTranslations() {
        return Translation;
    }

    public Vec3 getScaling() {
        return Scaling;
    }

    public ItemDisplayContext getTransformType() {
        return ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
    }

    public String getBone() {
        return "body";
    }

    public boolean canWear(LivingEntity entity) {
        return entity instanceof Starbuncle || entity instanceof FamiliarStarbuncle;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animationData) {
        animationData.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle_controller", 1, tAnimationEvent -> tAnimationEvent.setAndContinue(RawAnimation.begin().thenLoop("float")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

