/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common.item;

import alexthw.starbunclemania.client.JarRenderer;
import alexthw.starbunclemania.common.block.fluids.LiquidJarTile;
import alexthw.starbunclemania.common.item.JarStackFluidHandler;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FluidJarItem
extends BlockItem
implements GeoItem {
    final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public FluidJarItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new JarStackFluidHandler(stack, LiquidJarTile.capacity);
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            final JarRenderer.ISTER renderer = new JarRenderer.ISTER();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public static FluidStack getFluidFromTag(ItemStack stack) {
        if (!stack.m_41782_()) {
            return FluidStack.EMPTY;
        }
        CompoundTag blockTag = stack.m_41784_().m_128469_("BlockEntityTag");
        if (!blockTag.m_128456_()) {
            return FluidStack.loadFluidStackFromNBT((CompoundTag)blockTag);
        }
        return FluidStack.EMPTY;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        CompoundTag blockTag;
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
        if (pStack.m_41782_() && !(blockTag = pStack.m_41784_().m_128469_("BlockEntityTag")).m_128456_()) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)blockTag);
            LiquidJarTile.displayFluidTooltip(pTooltip, fluid);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animationData) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

