/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.crops;

import dev.ftb.mods.ftbultimine.ItemCollection;
import dev.ftb.mods.ftbultimine.crops.ICropLikeHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public enum VanillaCropLikeHandler implements ICropLikeHandler
{
    INSTANCE;


    public static boolean looksLikeACrop(BlockState state) {
        return state.m_60734_() instanceof BushBlock || state.m_60734_() instanceof CocoaBlock;
    }

    public static boolean equivalentForSelection(BlockState orig, BlockState other) {
        return VanillaCropLikeHandler.looksLikeACrop(orig) && VanillaCropLikeHandler.looksLikeACrop(other) && VanillaCropLikeHandler.getBushType(orig.m_60734_()) == VanillaCropLikeHandler.getBushType(other.m_60734_());
    }

    @Override
    public boolean isApplicable(Level level, BlockPos pos, BlockState state) {
        CropBlock cropBlock;
        Block block = state.m_60734_();
        return block instanceof CropBlock && (cropBlock = (CropBlock)block).m_52307_(state) || state.m_60734_() instanceof SweetBerryBushBlock && (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_) >= 3 || state.m_60734_() instanceof CocoaBlock && (Integer)state.m_61143_((Property)CocoaBlock.f_51736_) >= 2;
    }

    @Override
    public void doHarvesting(Player player, BlockPos pos, BlockState state, ItemCollection itemCollection) {
        BlockEntity blockEntity = state.m_155947_() ? player.m_9236_().m_7702_(pos) : null;
        List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)player.m_9236_()), (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)ItemStack.f_41583_);
        for (ItemStack stack : drops) {
            if (Block.m_49814_((Item)stack.m_41720_()) == state.m_60734_() && this.consumesItemToReplant(state)) {
                stack.m_41774_(1);
            }
            itemCollection.add(stack);
        }
        this.resetAge(player.m_9236_(), pos, state);
    }

    @Override
    public boolean isEquivalent(BlockState original, BlockState state) {
        return VanillaCropLikeHandler.equivalentForSelection(original, state);
    }

    private static int getBushType(Block block) {
        if (block instanceof CropBlock) {
            return 1;
        }
        if (block instanceof SaplingBlock) {
            return 2;
        }
        if (block instanceof CocoaBlock) {
            return 3;
        }
        if (block instanceof SweetBerryBushBlock) {
            return 4;
        }
        return 0;
    }

    private boolean consumesItemToReplant(BlockState state) {
        return state.m_60734_() != Blocks.f_50685_;
    }

    private void resetAge(Level level, BlockPos pos, BlockState currentState) {
        Block block = currentState.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            level.m_7731_(pos, cropBlock.m_52289_(0), 3);
        } else if (currentState.m_60734_() instanceof SweetBerryBushBlock) {
            int currentAge = (Integer)currentState.m_61143_((Property)SweetBerryBushBlock.f_57244_);
            level.m_7731_(pos, (BlockState)currentState.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(Math.min(currentAge, 1))), 3);
        } else if (currentState.m_60734_() instanceof CocoaBlock) {
            level.m_7731_(pos, (BlockState)currentState.m_61124_((Property)CocoaBlock.f_51736_, (Comparable)Integer.valueOf(0)), 3);
        }
    }
}

