/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.blocks.matrix;

import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import com.glodblock.github.extendedae.common.blocks.BlockBaseGui;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixBase;
import com.glodblock.github.extendedae.container.ContainerAssemblerMatrix;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public abstract class BlockAssemblerMatrixBase<M extends TileAssemblerMatrixBase>
extends BlockBaseGui<M> {
    public static final BooleanProperty FORMED = BooleanProperty.m_61465_((String)"formed");
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");

    public BlockAssemblerMatrixBase(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FORMED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockAssemblerMatrixBase() {
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FORMED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
        builder.m_61104_(new Property[]{FORMED});
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        BlockEntity te = level.m_7702_(currentPos);
        if (te != null) {
            te.requestModelDataUpdate();
        }
        return super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        TileAssemblerMatrixBase te = (TileAssemblerMatrixBase)this.getBlockEntity((BlockGetter)level, pos);
        if (te != null) {
            te.updateMultiBlock(fromPos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() == state.m_60734_()) {
            return;
        }
        TileAssemblerMatrixBase cp = (TileAssemblerMatrixBase)this.getBlockEntity((BlockGetter)level, pos);
        if (cp != null) {
            cp.breakCluster();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Override
    public void openGui(M tile, Player p) {
        if (((TileAssemblerMatrixBase)((Object)tile)).isActive() && ((TileAssemblerMatrixBase)((Object)tile)).isFormed()) {
            MenuOpener.open(ContainerAssemblerMatrix.TYPE, (Player)p, (MenuLocator)MenuLocators.forBlockEntity(tile));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        TileAssemblerMatrixBase tile = (TileAssemblerMatrixBase)this.getBlockEntity((BlockGetter)level, pos);
        if (tile != null && !tile.isFormed()) {
            return InteractionResult.PASS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    @Override
    public InteractionResult check(M tile, ItemStack stack, Level world, BlockPos pos, BlockHitResult hit, Player p) {
        if (!((TileAssemblerMatrixBase)((Object)tile)).isActive() && !((TileAssemblerMatrixBase)((Object)tile)).isFormed()) {
            return InteractionResult.PASS;
        }
        return null;
    }

    public abstract Item getPresentItem();
}

