/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.miscellaneous;

import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.tokenattributes.OffsetAttribute;
import guideme.internal.shaded.lucene.util.IgnoreRandomChains;
import java.io.IOException;

public final class LimitTokenOffsetFilter
extends TokenFilter {
    private final OffsetAttribute offsetAttrib = this.addAttribute(OffsetAttribute.class);
    private int maxStartOffset;
    private final boolean consumeAllTokens;

    @IgnoreRandomChains(reason="all tokens must be consumed")
    public LimitTokenOffsetFilter(TokenStream input, int maxStartOffset) {
        this(input, maxStartOffset, false);
    }

    public LimitTokenOffsetFilter(TokenStream input, int maxStartOffset, boolean consumeAllTokens) {
        super(input);
        if (maxStartOffset < 0) {
            throw new IllegalArgumentException("maxStartOffset must be >= zero");
        }
        this.maxStartOffset = maxStartOffset;
        this.consumeAllTokens = consumeAllTokens;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        if (this.offsetAttrib.startOffset() <= this.maxStartOffset) {
            return true;
        }
        if (this.consumeAllTokens) {
            while (this.input.incrementToken()) {
            }
        }
        return false;
    }
}

