/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.charfilter;

import guideme.internal.shaded.lucene.analysis.CharFilterFactory;
import guideme.internal.shaded.lucene.analysis.charfilter.HTMLStripCharFilter;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class HTMLStripCharFilterFactory
extends CharFilterFactory {
    public static final String NAME = "htmlStrip";
    final Set<String> escapedTags;
    static final Pattern TAG_NAME_PATTERN = Pattern.compile("[^\\s,]+");

    public HTMLStripCharFilterFactory(Map<String, String> args) {
        super(args);
        this.escapedTags = this.getSet(args, "escapedTags");
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public HTMLStripCharFilterFactory() {
        throw HTMLStripCharFilterFactory.defaultCtorException();
    }

    @Override
    public HTMLStripCharFilter create(Reader input) {
        HTMLStripCharFilter charFilter = null == this.escapedTags ? new HTMLStripCharFilter(input) : new HTMLStripCharFilter(input, this.escapedTags);
        return charFilter;
    }
}

