/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.experiencecrystal;

import de.melanx.utilitix.UtilitiXConfig;
import de.melanx.utilitix.util.BoundingBoxUtils;
import de.melanx.utilitix.util.XPUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.ITag;
import org.jetbrains.annotations.Nullable;
import org.moddingx.libx.base.tile.BlockEntityBase;
import org.moddingx.libx.base.tile.TickingBlock;

public class TileExperienceCrystal
extends BlockEntityBase
implements TickingBlock,
IFluidHandler {
    public static int MB_PER_XP = 20;
    private int xp;
    private Integer tankCount;
    private Fluid cachedXpFluid = null;

    public TileExperienceCrystal(BlockEntityType<?> blockEntityTypeIn, BlockPos pos, BlockState state) {
        super(blockEntityTypeIn, pos, state);
    }

    public void tick() {
        if (this.f_58857_ != null) {
            this.moveExps(this.f_58857_, this.f_58858_);
        }
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.xp = nbt.m_128451_("Xp");
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        compound.m_128405_("Xp", this.xp);
    }

    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        this.xp = nbt.m_128451_("Xp");
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("Xp", this.xp);
        return nbt;
    }

    public int getXp() {
        return this.xp;
    }

    public int addXp(int xp) {
        int add = Math.min(Math.max(0, xp), UtilitiXConfig.ExperienceCrystal.maxXp - this.xp);
        this.xp += add;
        this.m_6596_();
        this.setDispatchable();
        return add;
    }

    public int subtractXp(int xp) {
        int remove = Math.max(0, Math.min(xp, this.xp));
        this.xp -= remove;
        this.m_6596_();
        this.setDispatchable();
        return remove;
    }

    private void moveExps(Level level, BlockPos pos) {
        if (!UtilitiXConfig.ExperienceCrystal.pullOrbs || this.xp >= UtilitiXConfig.ExperienceCrystal.maxXp) {
            return;
        }
        List xps = level.m_45976_(ExperienceOrb.class, BoundingBoxUtils.expand(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), 7.0));
        for (ExperienceOrb orb : xps) {
            Vec3 vector = new Vec3((double)pos.m_123341_() - orb.m_20185_() + 0.5, (double)((float)pos.m_123342_() + orb.m_20192_() / 2.0f) - orb.m_20186_(), (double)pos.m_123343_() - orb.m_20189_() + 0.5);
            double scale = 1.0 - vector.m_82553_() / 8.0;
            orb.m_20256_(orb.m_20184_().m_82549_(vector.m_82541_().m_82490_(scale * scale * 0.1)));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (TileExperienceCrystal.validXpFluidIsPresent() && capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(capability, side);
    }

    public int getTanks() {
        if (this.tankCount == null) {
            long totalMb = (long)UtilitiXConfig.ExperienceCrystal.maxXp * (long)MB_PER_XP;
            this.tankCount = (int)(totalMb / Integer.MAX_VALUE);
            if (totalMb % Integer.MAX_VALUE != 0L) {
                Integer n = this.tankCount;
                this.tankCount = this.tankCount + 1;
            }
        }
        return this.tankCount;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        int xpForTank = this.getXpForTank(tank);
        return xpForTank <= 0 ? FluidStack.EMPTY : this.xpFluid().map(fluid -> new FluidStack(fluid, xpForTank)).orElse(FluidStack.EMPTY);
    }

    public int getTankCapacity(int tank) {
        long totalMb = (long)UtilitiXConfig.ExperienceCrystal.maxXp * (long)MB_PER_XP;
        int maxCapacityPerTank = Integer.MAX_VALUE;
        if (tank < this.getTanks() - 1) {
            return maxCapacityPerTank;
        }
        return (int)(totalMb - (long)maxCapacityPerTank * (long)tank);
    }

    public boolean isFluidValid(@Nonnull FluidStack stack) {
        return XPUtils.XP_FLUID_TAGS.stream().anyMatch(p -> TileExperienceCrystal.getFluidTag((TagKey<Fluid>)p).contains((Object)stack.getFluid()));
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isFluidValid(resource)) {
            return 0;
        }
        int xpToAdd = resource.getAmount() / MB_PER_XP;
        int totalXpAdded = 0;
        for (int tank = 0; tank < this.getTanks(); ++tank) {
            int xpInTank;
            int tankCapacity = this.getTankCapacity(tank);
            int xpCanAdd = Math.min(xpToAdd, tankCapacity / MB_PER_XP - (xpInTank = this.getXpForTank(tank)));
            if (xpCanAdd > 0) {
                xpToAdd -= xpCanAdd;
                totalXpAdded += xpCanAdd;
                if (action.execute()) {
                    this.addXp(xpCanAdd);
                }
            }
            if (xpToAdd <= 0) break;
        }
        return totalXpAdded * MB_PER_XP;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain(new FluidStack(this.getFluidInTank(0), maxDrain), action);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isFluidValid(resource) || resource.getAmount() == 0 || this.getFluidInTank(0).isEmpty()) {
            return FluidStack.EMPTY;
        }
        int xpToDrain = resource.getAmount() / MB_PER_XP;
        int totalXpDrained = 0;
        for (int tank = this.getTanks() - 1; tank >= 0; --tank) {
            int xpInTank = this.getXpForTank(tank);
            int xpCanDrain = Math.min(xpToDrain, xpInTank);
            if (xpCanDrain > 0) {
                xpToDrain -= xpCanDrain;
                totalXpDrained += xpCanDrain;
                if (action.execute()) {
                    this.subtractXp(xpCanDrain);
                }
            }
            if (xpToDrain <= 0) break;
        }
        return new FluidStack(resource.getFluid(), totalXpDrained * MB_PER_XP);
    }

    @Nonnull
    private static ITag<Fluid> getFluidTag(TagKey<Fluid> tag) {
        return Objects.requireNonNull(ForgeRegistries.FLUIDS.tags()).getTag(tag);
    }

    private int getXpForTank(int tank) {
        long fluidXp = (long)this.xp * (long)MB_PER_XP;
        if (tank == 0) {
            return fluidXp < Integer.MAX_VALUE ? (int)fluidXp : this.getTankCapacity(tank);
        }
        long xpRemaining = fluidXp;
        for (int i = 0; i < tank; ++i) {
            if (xpRemaining < Integer.MAX_VALUE) {
                return 0;
            }
            xpRemaining -= Integer.MAX_VALUE;
        }
        return (int)Math.min(xpRemaining, (long)this.getTankCapacity(tank));
    }

    public static boolean validXpFluidIsPresent() {
        return XPUtils.XP_FLUID_TAGS.stream().anyMatch(tag -> !TileExperienceCrystal.getFluidTag((TagKey<Fluid>)tag).isEmpty());
    }

    public Optional<Fluid> xpFluid() {
        if (this.cachedXpFluid == null) {
            this.cachedXpFluid = XPUtils.XP_FLUID_TAGS.stream().flatMap(tag -> TileExperienceCrystal.getFluidTag((TagKey<Fluid>)tag).stream()).filter(tag -> UtilitiXConfig.ExperienceCrystal.fluidXp.isPresent() && ForgeRegistries.FLUIDS.getKey(tag).equals((Object)UtilitiXConfig.ExperienceCrystal.fluidXp.get())).findFirst().or(() -> XPUtils.XP_FLUID_TAGS.stream().flatMap(tag -> TileExperienceCrystal.getFluidTag((TagKey<Fluid>)tag).stream()).min(Comparator.comparing(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getKey(arg_0)))).orElse(null);
        }
        return Optional.ofNullable(this.cachedXpFluid);
    }
}

