/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.crafting;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlanFlat;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;

public class HandlerWrappedTerminalCraftingPlan {
    private final ITerminalStorageTabIngredientCraftingHandler handler;
    private final ITerminalCraftingPlanFlat craftingPlanFlat;

    public HandlerWrappedTerminalCraftingPlan(ITerminalStorageTabIngredientCraftingHandler handler, ITerminalCraftingPlanFlat craftingPlanFlat) {
        this.handler = handler;
        this.craftingPlanFlat = craftingPlanFlat;
    }

    public ITerminalStorageTabIngredientCraftingHandler getHandler() {
        return this.handler;
    }

    public ITerminalCraftingPlanFlat getCraftingPlanFlat() {
        return this.craftingPlanFlat;
    }

    public static CompoundTag serialize(HandlerWrappedTerminalCraftingPlan craftingPlan) {
        ITerminalStorageTabIngredientCraftingHandler handler = craftingPlan.getHandler();
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("craftingPlanHandler", handler.getId().toString());
        tag.m_128365_("flatPlan", (Tag)handler.serializeCraftingPlanFlat(craftingPlan.getCraftingPlanFlat()));
        return tag;
    }

    public static HandlerWrappedTerminalCraftingPlan deserialize(CompoundTag tag) {
        if (!tag.m_128425_("craftingPlanHandler", 8)) {
            throw new IllegalArgumentException("Could not find a craftingPlanHandler entry in the given tag");
        }
        String handlerId = tag.m_128461_("craftingPlanHandler");
        ITerminalStorageTabIngredientCraftingHandler handler = TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandler(new ResourceLocation(handlerId));
        ITerminalCraftingPlanFlat craftingPlanFlat = handler.deserializeCraftingPlanFlat(tag.m_128469_("flatPlan"));
        return new HandlerWrappedTerminalCraftingPlan(handler, craftingPlanFlat);
    }
}

