/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.model;

import architectspalette.core.model.util.BakedModelWrapperWithData;
import architectspalette.core.model.util.QuadHelper;
import architectspalette.core.model.util.SpriteShift;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SheetMetalModel
extends BakedModelWrapperWithData {
    private static final ModelProperty<Data> CT_PROPERTY = new ModelProperty();
    private final SpriteShift spriteShift;

    public SheetMetalModel(BakedModel originalModel, SpriteShift spriteShift) {
        super(originalModel);
        this.spriteShift = spriteShift;
    }

    @Override
    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state) {
        Data data = new Data();
        SheetMetalModel.initializeData(world, pos, state, data);
        return builder.with(CT_PROPERTY, (Object)data);
    }

    private static void initializeData(BlockAndTintGetter world, BlockPos pos, BlockState state, Data data) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (Direction face : Direction.values()) {
            if (!Block.m_152444_((BlockState)state, (BlockGetter)world, (BlockPos)pos, (Direction)face, (BlockPos)checkPos.m_122159_((Vec3i)pos, face)) && !(state.m_60734_() instanceof WallBlock)) continue;
            int index = 1;
            boolean doShift = false;
            if (world.m_8055_((BlockPos)checkPos.m_122159_((Vec3i)pos, SheetMetalModel.getUpDirection(face))).getAppearance(world, (BlockPos)checkPos, face, state, pos).m_60713_(state.m_60734_())) {
                ++index;
                doShift = true;
            }
            if (world.m_8055_((BlockPos)checkPos.m_122159_((Vec3i)pos, SheetMetalModel.getDownDirection(face))).getAppearance(world, (BlockPos)checkPos, face, state, pos).m_60713_(state.m_60734_())) {
                --index;
                doShift = true;
            }
            if (!doShift) continue;
            data.set(face, index);
        }
    }

    private static Direction getUpDirection(Direction face) {
        return switch (face) {
            case Direction.UP -> Direction.NORTH;
            case Direction.DOWN -> Direction.SOUTH;
            default -> Direction.UP;
        };
    }

    private static Direction getDownDirection(Direction face) {
        return SheetMetalModel.getUpDirection(face).m_122424_();
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, extraData, renderType);
        if (!extraData.has(CT_PROPERTY)) {
            return quads;
        }
        Data data = (Data)extraData.get(CT_PROPERTY);
        if (data == null) {
            return quads;
        }
        quads = new ArrayList<BakedQuad>(quads);
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            Direction dir = quad.m_111306_();
            int index = data.get(dir);
            if (index == -1) continue;
            BakedQuad newQuad = QuadHelper.clone(quad);
            int[] vertexData = newQuad.m_111303_();
            float uShift = this.spriteShift.getUShift();
            float extraShift = this.spriteShift.getVHeight() * (float)index;
            float vShift = this.spriteShift.getVShift() + extraShift;
            for (int vertex = 0; vertex < 4; ++vertex) {
                float u = QuadHelper.getU(vertexData, vertex);
                float v = QuadHelper.getV(vertexData, vertex);
                QuadHelper.setU(vertexData, vertex, u + uShift);
                QuadHelper.setV(vertexData, vertex, v + vShift);
            }
            quads.set(i, newQuad);
        }
        return quads;
    }

    private static class Data {
        private final int[] indices = new int[6];

        public Data() {
            Arrays.fill(this.indices, -1);
        }

        public void set(Direction face, int index) {
            this.indices[face.m_122411_()] = index;
        }

        public int get(Direction face) {
            return this.indices[face.m_122411_()];
        }
    }
}

