/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.event;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="architects_palette")
public class TradingEventHandler {
    private static final Map<VillagerProfession, Map<Integer, LinkedList<VillagerTrades.ItemListing>>> professionMap = new HashMap<VillagerProfession, Map<Integer, LinkedList<VillagerTrades.ItemListing>>>();

    public static void add_trade(VillagerProfession prof, Integer level, VillagerTrades.ItemListing trade) {
        professionMap.putIfAbsent(prof, new HashMap());
        professionMap.get(prof).putIfAbsent(level, new LinkedList());
        professionMap.get(prof).get(level).add(trade);
    }

    private static void clear_map() {
        professionMap.clear();
    }

    @SubscribeEvent
    public static void onTradesLoaded(VillagerTradesEvent event) {
        VillagerProfession profession = event.getType();
        Map<Integer, LinkedList<VillagerTrades.ItemListing>> prof_trades = professionMap.get(profession);
        if (prof_trades != null) {
            Int2ObjectMap trades = event.getTrades();
            trades.forEach((level, list) -> {
                if (prof_trades.containsKey(level)) {
                    list.addAll((Collection)prof_trades.get(level));
                }
            });
        }
    }
}

