/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.worldgen.features;

import architectspalette.content.worldgen.features.configs.CrystalClusterConfig;
import architectspalette.core.registry.MiscRegistry;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CrystalClusterFeature
extends Feature<CrystalClusterConfig> {
    public CrystalClusterFeature(Codec<CrystalClusterConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<CrystalClusterConfig> context) {
        if (!context.m_159774_().m_46859_(context.m_159777_())) {
            return false;
        }
        if (((CrystalClusterConfig)context.m_159778_()).hanging ? context.m_159774_().m_46859_(context.m_159777_().m_7494_()) : context.m_159774_().m_46859_(context.m_159777_().m_7495_())) {
            return false;
        }
        CrystalClusterConfig config = (CrystalClusterConfig)context.m_159778_();
        RandomSource random = context.m_225041_();
        Vector3f shelfAngle = new Vector3f(-1.0f, 0.0f, 0.0f);
        shelfAngle.rotateY(random.m_188501_() * 2.0f * (float)Math.PI);
        Vector3f formationAngle = new Vector3f((Vector3fc)shelfAngle);
        formationAngle.rotateY((float)Math.toDegrees(CrystalClusterFeature.fRandomRange(random, -15.0f, 15.0f) + 90.0f));
        Vector3f placePos = new Vector3f((float)context.m_159777_().m_123341_(), (float)context.m_159777_().m_123342_(), (float)context.m_159777_().m_123343_());
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>(List.of());
        int shelves = CrystalClusterFeature.iRandomRange(random, 4, 7);
        for (int i = 0; i < shelves; ++i) {
            float scale = ((float)i + 1.0f) / (float)shelves;
            int pillars = CrystalClusterFeature.iRandomRange(random, 1, 7);
            CrystalClusterFeature.placeShelf(BlockPos.m_274561_((double)placePos.x(), (double)placePos.y(), (double)placePos.z()), pillars, shelfAngle, scale, context, posList);
            formationAngle.normalize();
            formationAngle.mul(CrystalClusterFeature.fRandomRange(random, 0.5f, 2.0f));
            placePos.add((Vector3fc)formationAngle);
        }
        for (BlockPos pos : posList) {
            CrystalClusterFeature.tryPlaceExtrusion(pos, context.m_159774_(), config.extrusionState, config.crystalState.m_60734_(), config.hanging ? 1 : -1, random);
        }
        return true;
    }

    private static void placeShelf(BlockPos startPos, int crystals, Vector3f shelfAngle, float shelfScale, FeaturePlaceContext<CrystalClusterConfig> context, List<BlockPos> crystalList) {
        RandomSource random = context.m_225041_();
        CrystalClusterConfig config = (CrystalClusterConfig)context.m_159778_();
        WorldGenLevel world = context.m_159774_();
        int flip = config.hanging ? 1 : -1;
        Vector3f placePos = new Vector3f((float)startPos.m_123341_(), (float)startPos.m_123342_(), (float)startPos.m_123343_());
        placePos.add(0.0f, (float)(-2 * flip), 0.0f);
        for (int i = 0; i < crystals; ++i) {
            Vector3f offset = new Vector3f((Vector3fc)shelfAngle);
            offset.mul(CrystalClusterFeature.fRandomRange(random, 0.5f, 2.5f));
            placePos.add((Vector3fc)offset);
            int pillarLength = config.minLength + random.m_188503_((int)Math.floor((float)(config.maxLength - config.minLength) * shelfScale) + 1);
            CrystalClusterFeature.placePillar(new BlockPos.MutableBlockPos((double)placePos.x(), (double)placePos.y(), (double)placePos.z()), pillarLength, world, context, flip, crystalList);
            if (pillarLength <= (config.maxLength - config.minLength) / 2 || !random.m_188499_()) continue;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos((double)(placePos.x() + (float)CrystalClusterFeature.iRandomRange(random, -1, 1)), (double)(placePos.y() + (float)CrystalClusterFeature.iRandomRange(random, -1, 1)), (double)(placePos.z() + (float)CrystalClusterFeature.iRandomRange(random, -1, 1)));
            CrystalClusterFeature.placePillar(pos, pillarLength / 2, world, context, flip, crystalList);
        }
    }

    private static void placePillar(BlockPos.MutableBlockPos placePos, int length, WorldGenLevel world, FeaturePlaceContext<CrystalClusterConfig> context, int flip, List<BlockPos> crystalList) {
        CrystalClusterConfig config = (CrystalClusterConfig)context.m_159778_();
        int tries = 10;
        while (CrystalClusterFeature.canReplaceAt(world, (BlockPos)placePos)) {
            placePos.m_142448_(placePos.m_123342_() + flip);
            if (world.m_8055_((BlockPos)placePos).m_60713_(Blocks.f_49991_)) {
                return;
            }
            if (tries-- != 0) continue;
            return;
        }
        tries = 5;
        while (!CrystalClusterFeature.canReplaceAt(world, (BlockPos)placePos)) {
            placePos.m_142448_(placePos.m_123342_() - flip);
            if (tries-- != 0) continue;
            return;
        }
        boolean doExtrusion = true;
        while (--length >= 0) {
            if (!CrystalClusterFeature.canReplaceAt(world, (BlockPos)placePos)) {
                return;
            }
            if (doExtrusion) {
                crystalList.add(placePos.m_7949_());
                doExtrusion = false;
            }
            world.m_7731_((BlockPos)placePos, config.crystalState, 2);
            placePos.m_142448_(placePos.m_123342_() - flip);
        }
    }

    private static void tryPlaceExtrusion(BlockPos startPos, WorldGenLevel level, BlockState placeState, Block avoidBlock, int flip, RandomSource random) {
        for (Direction dir : Direction.values()) {
            if (dir.m_122434_() == Direction.Axis.Y || random.m_188503_(3) != 1) continue;
            BlockPos pos = startPos.m_5484_(dir, 1);
            while (level.m_8055_(pos).m_60713_(placeState.m_60734_()) && Math.abs(startPos.m_123342_() - pos.m_123342_()) <= 4) {
                pos = pos.m_6625_(flip);
            }
            BlockPos above = pos.m_7494_();
            BlockPos below = pos.m_7495_();
            if (!(CrystalClusterFeature.canReplaceAt(level, above) ^ CrystalClusterFeature.canReplaceAt(level, below)) || level.m_8055_(above).m_60713_(avoidBlock) || level.m_8055_(below).m_60713_(avoidBlock)) continue;
            for (int i = CrystalClusterFeature.iRandomRange(random, 1, 2); i > 0 && CrystalClusterFeature.canReplaceAt(level, pos); --i) {
                level.m_7731_(pos, placeState, 2);
                pos = pos.m_6625_(flip);
            }
        }
    }

    private static int iRandomRange(RandomSource random, int min, int max) {
        return min + random.m_188503_(max - min + 1);
    }

    private static float fRandomRange(RandomSource random, float min, float max) {
        return min + random.m_188501_() * (max - min);
    }

    private static boolean canReplaceAt(WorldGenLevel level, BlockPos pos) {
        return CrystalClusterFeature.canReplace(level.m_8055_(pos));
    }

    private static boolean canReplace(BlockState state) {
        return state.m_60795_() || state.m_247087_() || state.m_204336_(MiscRegistry.CRYSTAL_REPLACEABLE);
    }
}

