/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.config;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.lyof.phantasm.Phantasm;
import net.lyof.phantasm.config.ConfigEntries;
import net.lyof.phantasm.config.ConfigEntry;
import org.apache.commons.io.FileUtils;

public class ModConfig {
    static final ConfigEntry<Double> VERSION = new ConfigEntry<Double>("TECHNICAL.VERSION_DO_NOT_EDIT", 0.0);
    static final ConfigEntry<Boolean> RELOAD = new ConfigEntry<Boolean>("TECHNICAL.FORCE_RESET", false);
    static Map CONFIG = new TreeMap();
    static final String DEFAULT_CONFIG = "{\n  \"TECHNICAL\": {\n    \"VERSION_DO_NOT_EDIT\": 1.5,\n    \"FORCE_RESET\": false\n  },\n\n  // This config file uses a custom defined parser. That's why there are comments here, they wouldn't be valid in any other .json file.\n  //    To add a comment yourself, just start a line with // like I did here\n  //    (although their main use is explaining you what the entries do)\n\n  // CATEGORY: WORLD GEN\n  \"world_gen\": {\n    \"biomes\": {\n      // Compatibility mode for datapacks modifying the End generation, such as Nullscape or Endercon\n      // Value must be one of:\n        // \"default\": Phantasm will replace an even proportion of the End Highlands with its custom biomes, mimicking its noise values\n          // theoretically works with any datapack, but might not be the prettiest\n        // \"nullscape\": Optimizes noise values to work best with Nullscape\n        // \"endercon\": Optimizes noise values to work best with Endercon\n        // \"automatic\": Same as default, but will work like \"nullscape\" or \"endercon\" depending on loaded mods\n          // if using the datapack versions, set this manually\n      \"datapack_compatibility\": \"automatic\",\n      // Should the End's biome source be partially overrode so that the main island biome always generate at the center\n      \"force_main_island\": true,\n\n      // DEAMING DEN\n      \"dreaming_den\": {\n        \"generate\": true,\n        \"generation_weight\": 1.5\n      },\n\n      // ACIDBURNT ABYSSES\n      \"acidburnt_abysses\": {\n        \"generate\": true,\n        // Fabric's biome API prioritizes biomes added first, so this one having a higher weight is only to balance that\n        \"generation_weight\": 2.5\n      }\n    },\n    // Should Fallen Stars appear in the End's sky\n    \"do_fallen_stars\": true,\n    // Should Raw Purpur stripes appear on the islands' sides\n    \"do_raw_purpur\": true,\n    // y offset to be added to the Raw Purpur stripes generation\n    \"raw_purpur_offset\": 0,\n\n    \"end_spires\": {\n      // Should the main island's obsidian spires be prettified with crying obsidian\n      \"beautify\": true,\n      // Should the main island's obsidian spires never have iron bars around the End Crystal\n      \"no_crystal_cages\": false,\n      // Height to be added to the spires, mostly useful in case of datapacks raising the main island level\n      \"extra_height\": 0\n    }\n  },\n\n  // CATEGORY: GAMEPLAY\n  \"gameplay\": {\n    // Should End portals teleport to the outer islands instead of the Dragon's\n    \"outer_end_in_gameloop\": true,\n\n    \"dragon\": {\n      // Should the Dragon's Fireballs create a firey explosion on impact\n      \"explosive_fireballs\": true,\n      // Should Endermen not be aggroed when looked at during the fight\n      \"no_pesky_endermen\": false\n    },\n\n    \"behemoth\": {\n      // Distance (in blocks) at which walking close to a Behemoth will aggro it\n      \"aggro_range\": 6,\n      // Distance (in blocks) at which walking close to a Behemoth while sneaking will aggro it\n      \"aggro_range_sneaking\": 0\n    }\n  },\n\n  // CATEGORY: EQUIPMENT\n  \"equipment\": {\n    // Advancement needed to enable elytra boosting. Leave blank \"\" to disable the need for one\n    \"elytra_boost_advancement\": \"minecraft:end/kill_dragon\",\n    // Crystalline tools boost ratio\n    \"crystal_xp_boost\": 3,\n\n    // Should eating a Chorus Fruit Salad teleport in/out of the End\n    \"chorus_fruit_salad_teleportation\": true,\n    // Max Chorus Fruit Salad stack size\n    \"chorus_fruit_salad_stack_size\": 1,\n\n    // Max uses for Shattered Pendants\n    \"shattered_pendant_durability\": 6,\n\n    // Range (in blocks) for Crossbow Choral Arrows and Subwoofer Blocks\n    \"subwoofer_range\": 6\n  }\n}";

    public static void register() {
        ModConfig.register(false);
    }

    public static void register(boolean force) {
        boolean create;
        String path = System.getProperty("user.dir") + File.separator + "config" + File.separator + "phantasm.json";
        Phantasm.log("Loading Configs for Phantasm");
        File config = new File(path);
        boolean bl = create = !config.isFile();
        if (create || force) {
            try {
                config.delete();
                config.createNewFile();
                FileWriter writer = new FileWriter(path);
                writer.write(DEFAULT_CONFIG);
                writer.close();
                Phantasm.log("Phantasm Config file created");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String configContent = DEFAULT_CONFIG;
        try {
            configContent = FileUtils.readFileToString((File)config, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CONFIG = (Map)new Gson().fromJson(ModConfig.parseJson(configContent), Map.class);
        ConfigEntries.reload();
        if (!force && (RELOAD.get().booleanValue() || VERSION.get() < ModConfig.getVersion())) {
            ModConfig.register(true);
        }
    }

    static String parseJson(String text) {
        StringBuilder result = new StringBuilder();
        for (String line : text.split("\n")) {
            if (line.strip().startsWith("//")) continue;
            result.append("\n").append(line);
        }
        return result.toString();
    }

    static double getVersion() {
        String text = DEFAULT_CONFIG;
        int start = 0;
        while (!List.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('.')).contains(Character.valueOf(text.charAt(start)))) {
            ++start;
        }
        int end = start + 1;
        while (List.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('.')).contains(Character.valueOf(text.charAt(end)))) {
            ++end;
        }
        return Double.parseDouble(text.substring(start, end));
    }
}

