/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.lyof.phantasm.entities.animations.BehemothAnimation;
import net.lyof.phantasm.entities.custom.BehemothEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BehemothModel<T extends BehemothEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("phantasm", "behemoth_model"), "main");
    public static final float rad = (float)Math.PI / 180;
    private final ModelPart body;
    private final ModelPart left_horn;
    private final ModelPart right_horn;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart zzz;

    public BehemothModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.left_horn = this.body.m_171324_("left_horn");
        this.right_horn = this.body.m_171324_("right_horn");
        this.left_leg = this.body.m_171324_("left_leg");
        this.right_leg = this.body.m_171324_("right_leg");
        this.zzz = root.m_171324_("zzz");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition body = modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-9.0f, -28.0f, -9.0f, 18.0f, 28.0f, 18.0f, new CubeDeformation(0.0f)).m_171514_(0, 87).m_171488_(-8.0f, -27.0f, -7.0f, 16.0f, 27.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(0, 47).m_171488_(-9.0f, 0.0f, -9.0f, 18.0f, 2.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)0.0f));
        PartDefinition left_horn = body.m_171599_("left_horn", CubeListBuilder.m_171558_().m_171514_(65, 39).m_171488_(0.0f, -6.0f, -9.0f, 6.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)9.0f, (float)-26.0f, (float)5.0f));
        PartDefinition right_horn = body.m_171599_("right_horn", CubeListBuilder.m_171558_().m_171514_(65, 39).m_171480_().m_171488_(-6.0f, -6.0f, -9.0f, 6.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-9.0f, (float)-26.0f, (float)5.0f));
        PartDefinition left_leg = body.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(55, 0).m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = body.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(55, 0).m_171480_().m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition zzz = modelPartData.m_171599_("zzz", CubeListBuilder.m_171558_().m_171514_(60, 101).m_171488_(0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)0.0f, (float)8.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        switch (((BehemothEntity)((Object)entity)).animation) {
            case WALKING: {
                this.body.f_104203_ = Mth.m_14031_((float)((float)(((BehemothEntity)((Object)entity)).animTicks * 3) * ((float)Math.PI / 180))) * 0.1f;
                this.left_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
                this.right_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
                break;
            }
            case SLEEPING: {
                this.body.f_104203_ = -1.5707964f;
                this.body.f_233555_ = (float)(1.0 + Math.sin((float)((BehemothEntity)((Object)entity)).animTicks * ((float)Math.PI / 180)) * 0.1);
                this.left_horn.f_233555_ = 1.0f;
                this.right_horn.f_233555_ = 1.0f;
                break;
            }
            case WAKING_UP: {
                this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                this.body.f_104203_ = Mth.m_14089_((float)((float)Math.PI / 180 * (float)((BehemothEntity)((Object)entity)).animTicks * 90.0f / (float)BehemothAnimation.WAKING_UP.maxTime)) * ((float)Math.PI / 180) * -90.0f;
                break;
            }
            case WAKING_DOWN: {
                this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                this.body.f_104203_ = Mth.m_14031_((float)((float)Math.PI / 180 * (float)((BehemothEntity)((Object)entity)).animTicks * 90.0f / (float)BehemothAnimation.WAKING_DOWN.maxTime)) * ((float)Math.PI / 180) * -90.0f;
            }
        }
    }

    public void m_7695_(PoseStack stack, VertexConsumer consumer, int light, int overlay, float red, float green, float blue, float alpha) {
        this.m_142109_().m_104306_(stack, consumer, light, overlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.body;
    }
}

