/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.walljump.network.message;

import com.google.common.collect.Lists;
import com.jahirtrap.walljump.init.ModConfig;
import com.jahirtrap.walljump.init.ServerConfig;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record MessageServerConfig(byte[] config) {
    public static void encode(MessageServerConfig message, FriendlyByteBuf buffer) {
        buffer.m_130087_(message.config);
    }

    public static MessageServerConfig decode(FriendlyByteBuf buffer) {
        return new MessageServerConfig(buffer.m_130052_());
    }

    public static void handle(MessageServerConfig message, Supplier<NetworkEvent.Context> supplier) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])message.config));
        ServerConfig.allowReClinging = buffer.readBoolean();
        ServerConfig.onFallDoubleJump = buffer.readBoolean();
        ServerConfig.onFallWallCling = buffer.readBoolean();
        ServerConfig.exhaustionWallJump = buffer.readDouble();
        ServerConfig.minFallDistance = buffer.readDouble();
        ServerConfig.elytraSpeedBoost = buffer.readDouble();
        ServerConfig.sprintSpeedBoost = buffer.readDouble();
        ServerConfig.stepAssist = buffer.readBoolean();
        ServerConfig.useDoubleJump = buffer.readBoolean();
        ServerConfig.useWallJump = buffer.readBoolean();
        ServerConfig.wallJumpHeight = buffer.readDouble();
        ServerConfig.wallSlideDelay = buffer.readInt();
        ServerConfig.stopWallSlideDelay = buffer.readInt();
        ServerConfig.maxWallJumps = buffer.readInt();
        ServerConfig.blockList = MessageServerConfig.readList(buffer);
        ServerConfig.blockListMode = (ModConfig.BlockListMode)buffer.m_130066_(ModConfig.BlockListMode.class);
        ServerConfig.enableEnchantments = buffer.readBoolean();
        ServerConfig.enableWallJump = buffer.readBoolean();
        ServerConfig.enableDoubleJump = buffer.readBoolean();
        ServerConfig.enableSpeedBoost = buffer.readBoolean();
        ServerConfig.speedBoostMultiplier = buffer.readDouble();
    }

    private static List<String> readList(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList list = Lists.newArrayListWithCapacity((int)size);
        for (int i = 0; i < size; ++i) {
            list.add(buffer.m_130277_());
        }
        return list;
    }
}

