/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.rebornstorage.items;

import com.refinedmods.refinedstorage.api.storage.StorageType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.refinedmods.refinedstorage.api.storage.disk.StorageDiskSyncData;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.render.Styles;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemFluidRebornStorageCell
extends Item
implements IStorageDiskProvider {
    private static final String NBT_ID = "Id";
    private final int capacity;

    public ItemFluidRebornStorageCell(int capacity, StorageType storageType) {
        super(new Item.Properties().m_41487_(1));
        this.capacity = capacity;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (!world.f_46443_ && !stack.m_41782_() && entity instanceof Player) {
            UUID id = UUID.randomUUID();
            API.instance().getStorageDiskManager((ServerLevel)world).set(id, API.instance().createDefaultFluidDisk((ServerLevel)world, this.getCapacity(stack), (Player)entity));
            API.instance().getStorageDiskManager((ServerLevel)world).markForSaving();
            this.setId(stack, id);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (this.isValid(stack)) {
            UUID id = this.getId(stack);
            API.instance().getStorageDiskSync().sendRequest(id);
            StorageDiskSyncData data = API.instance().getStorageDiskSync().getData(id);
            if (data != null) {
                if (data.getCapacity() == -1) {
                    tooltip.add((Component)Component.m_237110_((String)"misc.refinedstorage.storage.stored", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored())}).m_6270_(Styles.GRAY));
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"misc.refinedstorage.storage.stored_capacity", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored()), API.instance().getQuantityFormatter().format(data.getCapacity())}).m_6270_(Styles.GRAY));
                }
            }
            if (flag.m_7050_()) {
                tooltip.add((Component)Component.m_237113_((String)id.toString()));
            }
        }
    }

    public int getEntityLifespan(ItemStack stack, Level world) {
        return Integer.MAX_VALUE;
    }

    public UUID getId(ItemStack disk) {
        return disk.m_41783_().m_128342_(NBT_ID);
    }

    public void setId(ItemStack disk, UUID id) {
        disk.m_41751_(new CompoundTag());
        disk.m_41783_().m_128362_(NBT_ID, id);
    }

    public boolean isValid(ItemStack disk) {
        return disk.m_41782_() && disk.m_41783_().m_128403_(NBT_ID);
    }

    public int getCapacity(ItemStack disk) {
        return this.capacity;
    }

    public StorageType getType() {
        return StorageType.FLUID;
    }
}

