/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.container.ItemInventoryContainer;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLabeller;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.persist.world.LabelsWorldStorage;
import org.cyclops.integrateddynamics.item.ItemLabeller;

public class ContainerLabeller
extends ItemInventoryContainer<ItemLabeller> {
    private SimpleInventory temporaryInputSlots = new SimpleInventory(1, 1);
    @OnlyIn(value=Dist.CLIENT)
    private ContainerScreenLabeller gui;

    public ContainerLabeller(int id, Inventory inventory, FriendlyByteBuf packetBuffer) {
        this(id, inventory, ItemLocation.readFromPacketBuffer((FriendlyByteBuf)packetBuffer));
    }

    public ContainerLabeller(int id, Inventory inventory, ItemLocation itemLocation) {
        super(RegistryEntries.CONTAINER_LABELLER, id, inventory, itemLocation);
        this.m_38897_((Slot)new SlotExtended((Container)this.temporaryInputSlots, 0, 8, 8));
        this.addPlayerInventory(this.player.m_150109_(), 8, 31);
        if (inventory.f_35978_.m_9236_().m_5776_()) {
            this.temporaryInputSlots.addDirtyMarkListener(() -> {
                ItemStack itemStack = this.temporaryInputSlots.m_8020_(0);
                IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
                IVariableFacade variableFacade = registry.handle(ValueDeseralizationContext.of(inventory.f_35978_.m_9236_()), itemStack);
                String label = LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).getLabel(variableFacade.getId());
                if (label == null && !itemStack.m_41619_() && itemStack.m_41788_()) {
                    label = itemStack.m_41786_().getString();
                }
                if (label != null) {
                    this.getGui().setText(label);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setGui(ContainerScreenLabeller gui) {
        this.gui = gui;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ContainerScreenLabeller getGui() {
        return this.gui;
    }

    public ItemStack getItemStack() {
        return this.temporaryInputSlots.m_8020_(0);
    }

    protected int getSizeInventory() {
        return 1;
    }

    public void m_6877_(Player player) {
        ItemStack itemStack;
        super.m_6877_(player);
        if (!player.m_9236_().m_5776_() && !(itemStack = this.temporaryInputSlots.m_8020_(0)).m_41619_()) {
            Helpers.returnItemToPlayer(player, itemStack);
        }
    }

    public void setItemStackName(String name) {
        ItemStack itemStack = this.getItemStack();
        if (!itemStack.m_41619_()) {
            if (StringUtils.isBlank((CharSequence)name)) {
                itemStack.m_41787_();
            } else {
                itemStack.m_41714_((Component)Component.m_237113_((String)name));
            }
        }
    }
}

