/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.generator.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.information.IPowerInformation;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.generator.CoalGeneratorConfig;
import mcjty.rftoolspower.modules.generator.CoalGeneratorModule;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.IItemHandler;

public class CoalGeneratorTileEntity
extends TickingTileEntity {
    public static final int SLOT_COALINPUT = 0;
    public static final int SLOT_CHARGEITEM = 1;
    private static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(2).slot(SlotDefinition.specific(CoalGeneratorTileEntity::isValidFuel).in(), 0, 82, 24).slot(SlotDefinition.specific(EnergyTools::isEnergyItem).in().out(), 1, 118, 24).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> {
        if (slot == 0) {
            return CoalGeneratorTileEntity.isValidFuel(stack);
        }
        return EnergyTools.isEnergyItem((ItemStack)stack);
    }).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, false, (long)((Integer)CoalGeneratorConfig.MAXENERGY.get()).intValue(), 0L);
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Coal Generator").containerSupplier(DefaultContainerProvider.container(CoalGeneratorModule.CONTAINER_COALGENERATOR, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusable = new DefaultInfusable((BlockEntity)this);
    @Cap(type=CapType.POWER_INFO)
    private final IPowerInformation powerInfoHandler = this.createPowerInfo();
    private int burning;

    public CoalGeneratorTileEntity(BlockPos pos, BlockState state) {
        super(CoalGeneratorModule.TYPE_COALGENERATOR.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(CoalGeneratorTileEntity::new).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolspower:powergeneration/coalgenerator")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"info", stack -> CoalGeneratorConfig.RFPERTICK.get() + " RF/FE")})){

            protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.m_7926_(builder);
                builder.m_61104_(new Property[]{BlockStateProperties.f_61443_});
            }
        };
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void setPowerInput(int powered) {
        boolean changed = this.powerLevel != powered;
        super.setPowerInput(powered);
        if (changed) {
            this.m_6596_();
        }
    }

    protected void tickServer() {
        this.markDirtyQuick();
        this.handleChargingItem((IItemHandler)this.items);
        this.handleSendingEnergy();
        if (!this.isMachineEnabled()) {
            return;
        }
        this.handlePowerGeneration();
    }

    private void handlePowerGeneration() {
        if (this.burning > 0) {
            --this.burning;
            long rf = this.getRfPerTick();
            this.energyStorage.produceEnergy(rf);
        } else if (!this.items.getStackInSlot(0).m_41619_()) {
            ItemStack extracted = this.items.extractItem(0, 1, false);
            this.burning = (Integer)CoalGeneratorConfig.TICKSPERCOAL.get();
            if (extracted.m_41720_() == Blocks.f_50353_.m_5456_()) {
                this.burning *= 9;
            }
            float factor = this.infusable.getInfusedFactor();
            this.burning += (int)((float)this.burning * factor / 2.0f);
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue() != this.isWorking()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(this.isWorking())), 3);
        }
    }

    public long getRfPerTick() {
        long rf = ((Integer)CoalGeneratorConfig.RFPERTICK.get()).intValue();
        float factor = this.infusable.getInfusedFactor();
        rf += (long)((float)rf * factor);
        return rf;
    }

    public boolean isWorking() {
        return this.burning > 0 && this.isMachineEnabled();
    }

    private void handleChargingItem(IItemHandler handler) {
        ItemStack stack = handler.getStackInSlot(1);
        if (!stack.m_41619_()) {
            long storedPower = this.energyStorage.getEnergy();
            long rfToGive = Math.min((long)((Integer)CoalGeneratorConfig.CHARGEITEMPERTICK.get()).intValue(), storedPower);
            long received = EnergyTools.receiveEnergy((ItemStack)stack, (long)rfToGive);
            this.energyStorage.consumeEnergy(received);
        }
    }

    private void handleSendingEnergy() {
        long storedPower = this.energyStorage.getEnergy();
        EnergyTools.handleSendingEnergy((Level)this.f_58857_, (BlockPos)this.f_58858_, (long)storedPower, (long)((Integer)CoalGeneratorConfig.SENDPERTICK.get()).intValue(), (GenericEnergyStorage)this.energyStorage);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.burning = info.m_128451_("burning");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        CompoundTag infoTag = this.getOrCreateInfo(tagCompound);
        infoTag.m_128405_("burning", this.burning);
    }

    @Nonnull
    private IPowerInformation createPowerInfo() {
        return new IPowerInformation(){

            public long getEnergyDiffPerTick() {
                return CoalGeneratorTileEntity.this.burning > 0 ? CoalGeneratorTileEntity.this.getRfPerTick() : 0L;
            }

            public String getEnergyUnitName() {
                return "RF";
            }

            public boolean isMachineActive() {
                return CoalGeneratorTileEntity.this.isMachineEnabled();
            }

            public boolean isMachineRunning() {
                return CoalGeneratorTileEntity.this.isMachineEnabled();
            }

            public String getMachineStatus() {
                return CoalGeneratorTileEntity.this.burning > 0 ? "generating power" : "idle";
            }
        };
    }

    private static boolean isValidFuel(@Nonnull ItemStack stack) {
        return stack.m_41720_() == Items.f_42413_ || stack.m_41720_() == Items.f_42414_ || stack.m_41720_() == Items.f_42200_;
    }
}

