/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbase.tools.TickOrderHandler;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.endergenic.data.EnderMonitorMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;

public class EnderMonitorTileEntity
extends TickingTileEntity
implements TickOrderHandler.IOrderTicker {
    private final LogicSupport support = new LogicSupport();
    @GuiValue
    private EnderMonitorMode mode = EnderMonitorMode.MODE_LOSTPEARL;
    private boolean needpulse = false;
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Ender Monitor").containerSupplier(DefaultContainerProvider.empty(EndergenicModule.CONTAINER_ENDER_MONITOR, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolspower:powergeneration/endergenic")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(EnderMonitorTileEntity::new));
    }

    public EnderMonitorTileEntity(BlockPos pos, BlockState state) {
        super(EndergenicModule.TYPE_ENDER_MONITOR.get(), pos, state);
    }

    public EnderMonitorMode getMode() {
        return this.mode;
    }

    public void checkRedstone(Level world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public void setMode(EnderMonitorMode mode) {
        this.mode = mode;
        this.m_6596_();
    }

    public void fireFromEndergenic(EnderMonitorMode mode) {
        if (this.mode != mode) {
            return;
        }
        this.needpulse = true;
        this.markDirtyQuick();
    }

    protected void tickServer() {
        TickOrderHandler.queue((TickOrderHandler.IOrderTicker)this);
    }

    public TickOrderHandler.Rank getRank() {
        return TickOrderHandler.Rank.RANK_2;
    }

    public void tickOnServer() {
        int newout = 0;
        if (this.needpulse) {
            this.markDirtyQuick();
            newout = 15;
            this.needpulse = false;
        }
        this.support.setRedstoneState((GenericTileEntity)this, newout);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.support.setPowerOutput(tagCompound.m_128471_("rs") ? 15 : 0);
        this.needpulse = tagCompound.m_128471_("needPulse");
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        int m = info.m_128451_("mode");
        this.mode = EnderMonitorMode.values()[m];
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128379_("rs", this.support.getPowerOutput() > 0);
        tagCompound.m_128379_("needPulse", this.needpulse);
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        this.getOrCreateInfo(tagCompound).m_128405_("mode", this.mode.ordinal());
    }
}

