/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.dimensionalcell.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.api.infoscreen.IInformationScreenInfo;
import mcjty.rftoolsbase.modules.informationscreen.blocks.DefaultPowerInformationScreenInfo;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellTileEntity;
import mcjty.rftoolspower.modules.powercell.blocks.PowerCellInformationScreenInfo;
import mcjty.rftoolspower.modules.powercell.client.PowerCellInformationRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;

public class DimensionalCellInformationScreenInfo
implements IInformationScreenInfo {
    public static final int MODE_POWER_EXTENDED = 2;
    private final DimensionalCellTileEntity cell;
    private long lastExtracted = 0L;
    private long lastInserted = 0L;
    private long rfExtractPerTick = 0L;
    private long rfInsertedPerTick = 0L;

    public DimensionalCellInformationScreenInfo(DimensionalCellTileEntity cell) {
        this.cell = cell;
    }

    public int[] getSupportedModes() {
        return new int[]{0, 1, 2};
    }

    public void tick() {
        long newExtracted = this.cell.getTotalExtracted();
        long newInserted = this.cell.getTotalInserted();
        this.rfExtractPerTick = (newExtracted - this.lastExtracted) / 10L;
        this.rfInsertedPerTick = (newInserted - this.lastInserted) / 10L;
        this.lastExtracted = newExtracted;
        this.lastInserted = newInserted;
    }

    private long calculateRoughMaxRfPerTick() {
        return (long)this.cell.getRfPerTickPerSide() * 2L;
    }

    @Nonnull
    public TypedMap getInfo(int mode) {
        long energy = this.cell.getEnergy();
        long maxEnergy = this.cell.getMaxEnergyStored();
        return TypedMap.builder().put(DefaultPowerInformationScreenInfo.ENERGY, (Object)energy).put(DefaultPowerInformationScreenInfo.MAXENERGY, (Object)maxEnergy).put(PowerCellInformationScreenInfo.RFEXTRACT_PERTICK, (Object)this.rfExtractPerTick).put(PowerCellInformationScreenInfo.RFINSERT_PERTICK, (Object)this.rfInsertedPerTick).put(PowerCellInformationScreenInfo.ROUGH_MAXRF_PERTICK, (Object)this.calculateRoughMaxRfPerTick()).build();
    }

    public void render(int mode, PoseStack matrixStack, MultiBufferSource buffer, @Nonnull TypedMap data, Direction orientation, double scale) {
        if (mode == 0) {
            PowerCellInformationRenderer.renderDefault(matrixStack, buffer, data, orientation, scale);
        } else {
            PowerCellInformationRenderer.renderGraphical(matrixStack, buffer, mode, data, orientation, scale);
        }
    }
}

