/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine.simulation.modern;

import javax.annotation.Nullable;
import net.minecraft.world.level.material.Fluid;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.ITurbineFluidTank;
import net.roguelogix.biggerreactors.registries.FluidTransitionRegistry;
import net.roguelogix.biggerreactors.util.FluidTransitionTank;

public class FluidTank
extends FluidTransitionTank
implements ITurbineFluidTank {
    public FluidTank() {
        super(true);
    }

    @Override
    public void dumpLiquid() {
        this.dumpTank(1);
    }

    @Override
    public void dumpVapor() {
        this.dumpTank(0);
    }

    long flow(long amount, boolean ventExcess) {
        long maxTransitionable = this.inAmount;
        if (!ventExcess) {
            maxTransitionable = Math.min(maxTransitionable, this.perSideCapacity - this.outAmount);
        }
        this.maxTransitionedLastTick = amount;
        this.transitionedLastTick = amount = Math.min(maxTransitionable, amount);
        this.inAmount -= amount;
        this.outAmount += amount;
        if (ventExcess) {
            this.outAmount = Math.min(this.outAmount, this.perSideCapacity);
        }
        return this.transitionedLastTick;
    }

    @Override
    @Nullable
    protected FluidTransitionRegistry.FluidTransition selectTransition(Fluid fluid) {
        FluidTransitionRegistry.FluidTransition transition = super.selectTransition(fluid);
        if (transition != null && transition.turbineMultiplier == 0.0) {
            return null;
        }
        return transition;
    }
}

