/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor2.simulation;

import javax.annotation.ParametersAreNonnullByDefault;
import net.roguelogix.phosphophyllite.util.FastArraySet;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@ParametersAreNonnullByDefault
@NonnullDefault
public class SimulationDescription {
    public final int x;
    public final int y;
    public final int z;
    private final FastArraySet<Object> propertiesSet = new FastArraySet();
    private final int[] propertiesIndices;
    private final boolean[] controlRods;

    public SimulationDescription(int x, int y, int z) {
        if (x <= 0 || y <= 0 || z <= 0) {
            throw new IllegalArgumentException("All sizes must be greater than zero");
        }
        if ((long)x * (long)y * (long)z > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total volume must be under 2^31-1");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.propertiesIndices = new int[x * y * z];
        this.controlRods = new boolean[x * z];
    }

    private int arrayIndex(int x, int y, int z) {
        return this.x * x + y * this.y + z;
    }

    public void setBlockProperties(int x, int y, int z, Object properties) {
    }

    public void setControlRod(int x, int z) {
        this.controlRods[x * this.z + z] = true;
    }

    public boolean validate() {
        return true;
    }
}

