/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.client;

import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.client.Biselector;
import net.roguelogix.biggerreactors.client.CommonButton;
import net.roguelogix.biggerreactors.client.SelectorColors;
import net.roguelogix.biggerreactors.client.TextBox;
import net.roguelogix.biggerreactors.client.Triselector;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorRedstonePortContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorRedstonePortSelection;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorRedstonePortState;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorRedstonePortTriggers;
import net.roguelogix.phosphophyllite.client.gui.elements.AbstractElement;
import net.roguelogix.phosphophyllite.client.gui.elements.InteractiveElement;
import net.roguelogix.phosphophyllite.client.gui.elements.RenderedElement;
import net.roguelogix.phosphophyllite.client.gui.screens.PhosphophylliteScreen;

@OnlyIn(value=Dist.CLIENT)
public class ReactorRedstonePortScreen
extends PhosphophylliteScreen<ReactorRedstonePortContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/reactor_redstone_port.png");
    private static final String[] INPUT_TRANSLATIONS = new String[]{"screen.biggerreactors.reactor_redstone_port.input_reactor_activity", "screen.biggerreactors.reactor_redstone_port.input_control_rod_insertion", "screen.biggerreactors.reactor_redstone_port.input_eject_waste"};
    private static final String[] OUTPUT_TRANSLATIONS = new String[]{"screen.biggerreactors.reactor_redstone_port.output_fuel_temp", "screen.biggerreactors.reactor_redstone_port.output_casing_temp", "screen.biggerreactors.reactor_redstone_port.output_fuel_enrichment", "screen.biggerreactors.reactor_redstone_port.output_fuel_amount", "screen.biggerreactors.reactor_redstone_port.output_waste_amount", "screen.biggerreactors.reactor_redstone_port.output_output_stored"};
    private ReactorRedstonePortState reactorRedstonePortState = (ReactorRedstonePortState)((ReactorRedstonePortContainer)this.m_6262_()).getGuiPacket();
    InteractiveElement<ReactorRedstonePortContainer> applyChangesButton;
    InteractiveElement<ReactorRedstonePortContainer> revertChangesButton;
    Biselector<ReactorRedstonePortContainer> triggerTypeToggle;
    Triselector<ReactorRedstonePortContainer> triggerModeToggle;
    TextBox<ReactorRedstonePortContainer> textBufferA;
    CommonButton<ReactorRedstonePortContainer> textEnterButtonA;
    TextBox<ReactorRedstonePortContainer> textBufferB;
    CommonButton<ReactorRedstonePortContainer> textEnterButtonB;
    RenderedElement<ReactorRedstonePortContainer> selectedTabSymbol;

    public ReactorRedstonePortScreen(ReactorRedstonePortContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title, DEFAULT_TEXTURE, 200, 178);
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.m_96636_())) / 2;
        this.initControls();
        this.initSymbols();
    }

    public void initControls() {
        int cI;
        int i = 0;
        while (i < 3) {
            cI = i++;
            InteractiveElement inputTab = new InteractiveElement((PhosphophylliteScreen)this, 0, cI * 25, 25, 24, 206, cI * 24, (Component)Component.m_237115_((String)(INPUT_TRANSLATIONS[cI] + ".tooltip")));
            inputTab.onMouseReleased = (mX, mY, btn) -> {
                if (inputTab.m_5953_(mX, mY)) {
                    ((ReactorRedstonePortContainer)this.m_6262_()).executeRequest("setSelectedTab", cI);
                    this.reactorRedstonePortState.selectedTab = ReactorRedstonePortSelection.fromInt(cI);
                    inputTab.playSound(SoundEvents.f_12490_);
                    return true;
                }
                return false;
            };
            inputTab.onRender = (mS, mX, mY) -> {
                if (inputTab.stateEnable) {
                    inputTab.blit(mS, 231, cI * 24);
                } else {
                    inputTab.blit(mS, 206, cI * 24);
                }
            };
            inputTab.onTick = () -> {
                inputTab.stateEnable = this.reactorRedstonePortState.selectedTab == ReactorRedstonePortSelection.fromInt(cI);
            };
            this.addScreenElement((AbstractElement)inputTab);
        }
        i = 0;
        while (i < 6) {
            cI = i++;
            InteractiveElement outputTab = new InteractiveElement((PhosphophylliteScreen)this, 175, cI * 25, 25, 24, 206, cI * 24 + 72, (Component)Component.m_237115_((String)(OUTPUT_TRANSLATIONS[cI] + ".tooltip")));
            outputTab.onMouseReleased = (mX, mY, btn) -> {
                if (outputTab.m_5953_(mX, mY)) {
                    ((ReactorRedstonePortContainer)this.m_6262_()).executeRequest("setSelectedTab", cI + 3);
                    this.reactorRedstonePortState.selectedTab = ReactorRedstonePortSelection.fromInt(cI + 3);
                    outputTab.playSound(SoundEvents.f_12490_);
                    return true;
                }
                return false;
            };
            outputTab.onRender = (mS, mX, mY) -> {
                if (outputTab.stateEnable) {
                    outputTab.blit(mS, 231, cI * 24 + 72);
                } else {
                    outputTab.blit(mS, 206, cI * 24 + 72);
                }
            };
            outputTab.onTick = () -> {
                outputTab.stateEnable = this.reactorRedstonePortState.selectedTab == ReactorRedstonePortSelection.fromInt(cI + 3);
            };
            this.addScreenElement((AbstractElement)outputTab);
        }
        this.applyChangesButton = new InteractiveElement((PhosphophylliteScreen)this, 156, 156, 15, 15, 226, 216, (Component)Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.apply_changes.tooltip"));
        this.applyChangesButton.onMouseReleased = (mX, mY, btn) -> {
            if (this.applyChangesButton.m_5953_(mX, mY)) {
                if (this.reactorRedstonePortState.isInput()) {
                    ((ReactorRedstonePortContainer)this.m_6262_()).executeRequest("setTriggerPS", this.triggerTypeToggle.getState() != 0);
                } else {
                    ((ReactorRedstonePortContainer)this.m_6262_()).executeRequest("setTriggerAB", this.triggerTypeToggle.getState() != 0);
                }
                ((ReactorRedstonePortContainer)this.m_6262_()).executeRequest("setTriggerMode", this.triggerModeToggle.getState());
                ((ReactorRedstonePortContainer)this.m_6262_()).executeRequest("setTextBufferA", this.textBufferA.getContents().replaceAll("[^\\d.]", ""));
                ((ReactorRedstonePortContainer)this.m_6262_()).executeRequest("setTextBufferB", this.textBufferB.getContents().replaceAll("[^\\d.]", ""));
                ((ReactorRedstonePortContainer)this.m_6262_()).executeRequest("applyChanges", 0);
                this.applyChangesButton.playSound(SoundEvents.f_12490_);
                return true;
            }
            return false;
        };
        this.applyChangesButton.onRender = (mS, mX, mY) -> {
            if (this.applyChangesButton.m_5953_((double)mX, (double)mY)) {
                this.applyChangesButton.blit(mS, 241, 216);
            } else {
                this.applyChangesButton.blit(mS, 226, 216);
            }
        };
        this.addScreenElement((AbstractElement)this.applyChangesButton);
        this.revertChangesButton = new InteractiveElement((PhosphophylliteScreen)this, 138, 156, 15, 15, 226, 231, (Component)Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.revert_changes.tooltip"));
        this.revertChangesButton.onMouseReleased = (mX, mY, btn) -> {
            if (this.revertChangesButton.m_5953_(mX, mY)) {
                ((ReactorRedstonePortContainer)this.m_6262_()).executeRequest("revertChanges", 0);
                this.revertChangesButton.playSound(SoundEvents.f_12490_);
                return true;
            }
            return false;
        };
        this.revertChangesButton.onRender = (mS, mX, mY) -> {
            if (this.revertChangesButton.m_5953_((double)mX, (double)mY)) {
                this.revertChangesButton.blit(mS, 241, 231);
            } else {
                this.revertChangesButton.blit(mS, 226, 231);
            }
        };
        this.triggerTypeToggle = new Biselector<ReactorRedstonePortContainer>(this, 29, 42, (Component)Component.m_237119_(), () -> this.reactorRedstonePortState.triggerPS.toBool() || this.reactorRedstonePortState.triggerAB.toBool() ? 1 : 0, SelectorColors.YELLOW, SelectorColors.RED);
        this.triggerTypeToggle.onMouseReleased = (mX, mY, btn) -> {
            if (this.reactorRedstonePortState.isInput()) {
                ((ReactorRedstonePortContainer)this.m_6262_()).executeRequest("setTriggerPS", this.triggerTypeToggle.getState() == 0);
            } else {
                ((ReactorRedstonePortContainer)this.m_6262_()).executeRequest("setTriggerAB", this.triggerTypeToggle.getState() == 0);
            }
            return true;
        };
        this.triggerTypeToggle.onTick = () -> {
            this.triggerTypeToggle.tooltip = this.reactorRedstonePortState.isInput() ? Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.trigger_type_toggle.ps.tooltip") : Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.trigger_type_toggle.ab.tooltip");
        };
        this.addScreenElement((AbstractElement)this.triggerTypeToggle);
        this.triggerModeToggle = new Triselector<ReactorRedstonePortContainer>(this, 29, 58, (Component)Component.m_237115_((String)"screen.biggerreactors.reactor_terminal.auto_eject_toggle.tooltip"), () -> this.reactorRedstonePortState.triggerMode, SelectorColors.GREEN, SelectorColors.RED, SelectorColors.YELLOW);
        this.triggerModeToggle.onMouseReleased = (mX, mY, btn) -> {
            ((ReactorRedstonePortContainer)this.m_6262_()).executeRequest("setTriggerMode", this.triggerModeToggle.getState());
            return true;
        };
        this.addScreenElement((AbstractElement)this.triggerModeToggle);
        this.textBufferA = new TextBox<ReactorRedstonePortContainer>(this, this.f_96547_, 27, 91, 96, 16, this.reactorRedstonePortState.textBufferA);
        this.addScreenElement((AbstractElement)this.textBufferA);
        this.textEnterButtonA = new CommonButton<ReactorRedstonePortContainer>(this, 135, 92, 17, 14, 61, 130, (Component)Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.apply.tooltip"));
        this.textEnterButtonA.onMouseReleased = (mX, mY, btn) -> {
            ((ReactorRedstonePortContainer)this.m_6262_()).executeRequest("setTextBufferA", this.textBufferA.getContents().replaceAll("[^\\d.]", ""));
            return true;
        };
        this.addScreenElement((AbstractElement)this.textEnterButtonA);
        this.textBufferB = new TextBox<ReactorRedstonePortContainer>(this, this.f_96547_, 27, 122, 96, 16, this.reactorRedstonePortState.textBufferB);
        this.addScreenElement((AbstractElement)this.textBufferB);
        this.textEnterButtonB = new CommonButton<ReactorRedstonePortContainer>(this, 135, 123, 17, 14, 61, 130, (Component)Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.apply.tooltip"));
        this.textEnterButtonB.onMouseReleased = (mX, mY, btn) -> {
            ((ReactorRedstonePortContainer)this.m_6262_()).executeRequest("setTextBufferB", this.textBufferB.getContents().replaceAll("[^\\d.]", ""));
            return true;
        };
        this.addScreenElement((AbstractElement)this.textEnterButtonB);
    }

    public void initSymbols() {
        this.selectedTabSymbol = new RenderedElement((PhosphophylliteScreen)this, 92, 20, 16, 16, 25, 4, (Component)Component.m_237119_());
        this.selectedTabSymbol.onTick = () -> {
            this.selectedTabSymbol.tooltip = Component.m_237115_((String)(this.reactorRedstonePortState.isInput() ? INPUT_TRANSLATIONS[this.reactorRedstonePortState.selectedTab.toInt()] : OUTPUT_TRANSLATIONS[this.reactorRedstonePortState.selectedTab.toInt() - 3]));
            this.selectedTabSymbol.u = this.reactorRedstonePortState.isInput() ? 235 : 236;
            this.selectedTabSymbol.v = this.reactorRedstonePortState.selectedTab.toInt() * 24 + 4;
        };
        this.addScreenElement((AbstractElement)this.selectedTabSymbol);
    }

    public void m_181908_() {
        super.m_181908_();
        switch (this.reactorRedstonePortState.selectedTab) {
            case INPUT_CONTROL_ROD_INSERTION: {
                this.textBufferA.actionEnable = true;
                this.textEnterButtonA.actionEnable = true;
                if (this.reactorRedstonePortState.triggerPS == ReactorRedstonePortTriggers.PULSE_OR_ABOVE) {
                    this.triggerModeToggle.actionEnable = true;
                    this.textBufferB.actionEnable = false;
                    this.textBufferB.clear();
                    this.textEnterButtonB.actionEnable = false;
                    break;
                }
                this.triggerModeToggle.actionEnable = false;
                this.textBufferB.actionEnable = true;
                this.textEnterButtonB.actionEnable = true;
                break;
            }
            case OUTPUT_FUEL_TEMP: 
            case OUTPUT_CASING_TEMP: 
            case OUTPUT_FUEL_ENRICHMENT: 
            case OUTPUT_FUEL_AMOUNT: 
            case OUTPUT_WASTE_AMOUNT: 
            case OUTPUT_ENERGY_AMOUNT: {
                this.triggerModeToggle.actionEnable = false;
                this.textBufferA.actionEnable = true;
                this.textEnterButtonA.actionEnable = true;
                this.textBufferB.actionEnable = false;
                this.textBufferB.clear();
                this.textEnterButtonB.actionEnable = false;
                break;
            }
            default: {
                this.triggerModeToggle.actionEnable = false;
                if (this.textBufferA.actionEnable || this.textEnterButtonA.actionEnable) {
                    this.textBufferA.clear();
                    this.textBufferA.actionEnable = false;
                    this.textEnterButtonA.actionEnable = false;
                }
                if (!this.textBufferB.actionEnable && !this.textEnterButtonB.actionEnable) break;
                this.textBufferB.clear();
                this.textBufferB.actionEnable = false;
                this.textEnterButtonB.actionEnable = false;
            }
        }
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.reactorRedstonePortState.isInput()) {
            if (this.reactorRedstonePortState.triggerPS == ReactorRedstonePortTriggers.PULSE_OR_ABOVE) {
                graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.trigger_type_toggle.ps.on_pulse").getString(), this.getGuiLeft() + 63, this.getGuiTop() + 45, 0x404040, false);
            } else {
                graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.trigger_type_toggle.ps.on_signal").getString(), this.getGuiLeft() + 63, this.getGuiTop() + 45, 0x404040, false);
            }
        } else if (this.reactorRedstonePortState.triggerAB == ReactorRedstonePortTriggers.PULSE_OR_ABOVE) {
            graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.trigger_type_toggle.ab.while_above").getString(), this.getGuiLeft() + 63, this.getGuiTop() + 45, 0x404040, false);
        } else {
            graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.trigger_type_toggle.ab.while_below").getString(), this.getGuiLeft() + 63, this.getGuiTop() + 45, 0x404040, false);
        }
        switch (this.reactorRedstonePortState.selectedTab) {
            case INPUT_CONTROL_ROD_INSERTION: {
                if (this.reactorRedstonePortState.triggerPS == ReactorRedstonePortTriggers.PULSE_OR_ABOVE) {
                    if (this.reactorRedstonePortState.triggerMode == 0) {
                        graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.trigger_mode_toggle.mode_a").getString(), this.getGuiLeft() + 80, this.getGuiTop() + 62, 0x404040, false);
                        graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.text_buffer_a.mode_a").getString(), this.getGuiLeft() + 29, this.getGuiTop() + 82, 0x404040, false);
                        break;
                    }
                    if (this.reactorRedstonePortState.triggerMode == 1) {
                        graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.trigger_mode_toggle.mode_b").getString(), this.getGuiLeft() + 80, this.getGuiTop() + 62, 0x404040, false);
                        graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.text_buffer_a.mode_b").getString(), this.getGuiLeft() + 29, this.getGuiTop() + 82, 0x404040, false);
                        break;
                    }
                    graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.trigger_mode_toggle.mode_c").getString(), this.getGuiLeft() + 80, this.getGuiTop() + 62, 0x404040, false);
                    graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.text_buffer_a.mode_c").getString(), this.getGuiLeft() + 29, this.getGuiTop() + 82, 0x404040, false);
                    break;
                }
                graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.input_control_rod_insertion.while_on").getString(), this.getGuiLeft() + 29, this.getGuiTop() + 82, 0x404040, false);
                graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.input_control_rod_insertion.while_off").getString(), this.getGuiLeft() + 29, this.getGuiTop() + 113, 0x404040, false);
                break;
            }
            case OUTPUT_FUEL_TEMP: 
            case OUTPUT_CASING_TEMP: {
                graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.text_buffer_a.trigger_at").getString(), this.getGuiLeft() + 29, this.getGuiTop() + 82, 0x404040, false);
                graphics.m_280056_(this.getFont(), "\u00b0C", this.getGuiLeft() + 155, this.getGuiTop() + 96, 0x404040, false);
                break;
            }
            case OUTPUT_FUEL_ENRICHMENT: 
            case OUTPUT_ENERGY_AMOUNT: {
                graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.text_buffer_a.trigger_at").getString(), this.getGuiLeft() + 29, this.getGuiTop() + 82, 0x404040, false);
                graphics.m_280056_(this.getFont(), "%", this.getGuiLeft() + 155, this.getGuiTop() + 96, 0x404040, false);
                break;
            }
            case OUTPUT_FUEL_AMOUNT: 
            case OUTPUT_WASTE_AMOUNT: {
                graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.text_buffer_a.trigger_at").getString(), this.getGuiLeft() + 29, this.getGuiTop() + 82, 0x404040, false);
                graphics.m_280056_(this.getFont(), "mB", this.getGuiLeft() + 155, this.getGuiTop() + 96, 0x404040, false);
            }
        }
    }
}

