/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.client;

import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.client.CommonRender;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.ActiveReactorTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.CommonReactorTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorState;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorType;
import net.roguelogix.phosphophyllite.client.gui.RenderHelper;
import net.roguelogix.phosphophyllite.client.gui.elements.AbstractElement;
import net.roguelogix.phosphophyllite.client.gui.elements.RenderedElement;
import net.roguelogix.phosphophyllite.client.gui.elements.TooltipElement;
import net.roguelogix.phosphophyllite.client.gui.screens.PhosphophylliteScreen;

@OnlyIn(value=Dist.CLIENT)
public class PassiveReactorTerminalScreen
extends PhosphophylliteScreen<ReactorTerminalContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/reactor_terminal_passive.png");
    private ReactorState reactorState = (ReactorState)((ReactorTerminalContainer)this.m_6262_()).getGuiPacket();

    public PassiveReactorTerminalScreen(ReactorTerminalContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title, DEFAULT_TEXTURE, 176, 152);
    }

    public void m_7856_() {
        super.m_7856_();
        CommonReactorTerminalScreen.initTooltips(this, this.reactorState);
        this.initTooltips();
        CommonReactorTerminalScreen.initControls(this, this.reactorState);
        CommonReactorTerminalScreen.initGauges(this, this.reactorState);
        this.initGauges();
        CommonReactorTerminalScreen.initSymbols(this, this.reactorState);
    }

    private void initTooltips() {
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 8, 38, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.reactor_terminal.energy_generation_rate.tooltip")));
        TooltipElement generationRateReadoutTooltip = new TooltipElement((PhosphophylliteScreen)this, 26, 38, 53, 16, (Component)Component.m_237119_());
        generationRateReadoutTooltip.onTick = () -> {
            generationRateReadoutTooltip.tooltip = Component.m_237113_((String)String.format("%.3f RF/t", this.reactorState.reactorOutputRate));
        };
        this.addScreenElement((AbstractElement)generationRateReadoutTooltip);
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 152, 6, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.reactor_terminal.internal_battery.tooltip")));
    }

    private void initGauges() {
        RenderedElement internalBattery = new RenderedElement((PhosphophylliteScreen)this, 151, 25, 18, 64, 0, 152, (Component)Component.m_237119_());
        internalBattery.onRender = (graphics, mX, mY) -> CommonRender.renderEnergyGauge(graphics, internalBattery, this.reactorState.energyStored, this.reactorState.energyCapacity);
        this.addScreenElement((AbstractElement)internalBattery);
    }

    public void m_181908_() {
        this.reactorState = (ReactorState)((ReactorTerminalContainer)this.m_6262_()).getGuiPacket();
        super.m_181908_();
        if (this.reactorState.reactorType != ReactorType.PASSIVE) {
            this.getMinecraft().m_91152_((Screen)new ActiveReactorTerminalScreen((ReactorTerminalContainer)this.f_97732_, this.inventory, this.f_96539_));
        }
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        CommonReactorTerminalScreen.renderStatusText(graphics, this, this.reactorState.reactorActivity, this.reactorState.doAutoEject, this.reactorState.fuelHeatStored, this.reactorState.fuelUsageRate, this.reactorState.reactivityRate);
        graphics.m_280056_(this.getFont(), RenderHelper.formatValue((double)this.reactorState.reactorOutputRate, (String)"RF/t"), this.getGuiLeft() + 27, this.getGuiTop() + 42, 0x404040, false);
    }
}

