/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles;

import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.blocks.HeatExchangerCondenserChannelBlock;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles.HeatExchangerBaseTile;
import net.roguelogix.phosphophyllite.modular.block.IConnectedTexture;
import net.roguelogix.phosphophyllite.registry.RegisterTile;
import net.roguelogix.phosphophyllite.util.VectorUtil;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.Mesh;
import net.roguelogix.quartz.Quartz;
import net.roguelogix.quartz.QuartzEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class HeatExchangerChannelTile
extends HeatExchangerBaseTile {
    public final boolean CONDENSER;
    public long lastCheckedTick;
    @RegisterTile(value="heat_exchanger_channel")
    public static final BlockEntityType.BlockEntitySupplier<HeatExchangerChannelTile> SUPPLIER = new RegisterTile.Producer(HeatExchangerChannelTile::new);
    private static Mesh condenserConnectionErrorMesh;
    private static Mesh condenserStraightMesh;
    private static Mesh condenserCornerMesh;
    private static Mesh evaporatorConnectionErrorMesh;
    private static Mesh evaporatorStraightMesh;
    private static Mesh evaporatorCornerMesh;
    private static final ReferenceArrayList<Matrix4f> rotationMatrices;
    private static final int TOP_CONNECTED_BIT = 1;
    private static final int BOTTOM_CONNECTED_BIT = 2;
    private static final int NORTH_CONNECTED_BIT = 4;
    private static final int SOUTH_CONNECTED_BIT = 8;
    private static final int EAST_CONNECTED_BIT = 16;
    private static final int WEST_CONNECTED_BIT = 32;
    private DrawBatch.Instance instance;

    public HeatExchangerChannelTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.CONDENSER = state.m_60734_() == HeatExchangerCondenserChannelBlock.INSTANCE;
    }

    private static void onQuartzStartup(QuartzEvent.Startup quartzStartup) {
        condenserConnectionErrorMesh = Quartz.createStaticMesh((ResourceLocation)new ResourceLocation("biggerreactors:block/heat_exchanger/casing/corner"));
        condenserStraightMesh = Quartz.createStaticMesh((ResourceLocation)new ResourceLocation("biggerreactors:block/heat_exchanger/hot_channel/connected_tb"));
        condenserCornerMesh = Quartz.createStaticMesh((ResourceLocation)new ResourceLocation("biggerreactors:block/heat_exchanger/hot_channel/connected_bn"));
        evaporatorConnectionErrorMesh = Quartz.createStaticMesh((ResourceLocation)new ResourceLocation("biggerreactors:block/heat_exchanger/casing/corner"));
        evaporatorStraightMesh = Quartz.createStaticMesh((ResourceLocation)new ResourceLocation("biggerreactors:block/heat_exchanger/cold_channel/connected_tb"));
        evaporatorCornerMesh = Quartz.createStaticMesh((ResourceLocation)new ResourceLocation("biggerreactors:block/heat_exchanger/cold_channel/connected_bn"));
    }

    public void onAdded() {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_5776_()) {
            return;
        }
        this.createModel();
    }

    public void onRemoved(boolean chunkUnload) {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_5776_()) {
            return;
        }
        this.destroyModel();
    }

    public void m_155250_(BlockState p_155251_) {
        super.m_155250_(p_155251_);
        this.rebuildModel();
    }

    public void rebuildModel() {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_5776_()) {
            return;
        }
        this.destroyModel();
        this.createModel();
    }

    public void createModel() {
        Vector3i position = VectorUtil.fromBlockPos((BlockPos)this.m_58899_());
        DrawBatch batcher = Quartz.getDrawBatcherForBlock((Vector3ic)position);
        Mesh mesh = this.CONDENSER ? condenserConnectionErrorMesh : evaporatorConnectionErrorMesh;
        BlockState state = this.m_58900_();
        int connectedSides = 0;
        connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.TOP_CONNECTED_PROPERTY) != false ? 1 : 0;
        connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.BOTTOM_CONNECTED_PROPERTY) != false ? 1 : 0;
        connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.NORTH_CONNECTED_PROPERTY) != false ? 1 : 0;
        connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.SOUTH_CONNECTED_PROPERTY) != false ? 1 : 0;
        connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.EAST_CONNECTED_PROPERTY) != false ? 1 : 0;
        int n = (Boolean)state.m_61143_((Property)IConnectedTexture.Module.WEST_CONNECTED_PROPERTY) != false ? 1 : 0;
        Matrix4f rotationMatrix = null;
        if ((connectedSides += n) <= 2) {
            int sideConnectionFlags = 0;
            sideConnectionFlags |= (Boolean)state.m_61143_((Property)IConnectedTexture.Module.TOP_CONNECTED_PROPERTY) != false ? 1 : 0;
            sideConnectionFlags |= (Boolean)state.m_61143_((Property)IConnectedTexture.Module.BOTTOM_CONNECTED_PROPERTY) != false ? 2 : 0;
            sideConnectionFlags |= (Boolean)state.m_61143_((Property)IConnectedTexture.Module.NORTH_CONNECTED_PROPERTY) != false ? 4 : 0;
            sideConnectionFlags |= (Boolean)state.m_61143_((Property)IConnectedTexture.Module.SOUTH_CONNECTED_PROPERTY) != false ? 8 : 0;
            sideConnectionFlags |= (Boolean)state.m_61143_((Property)IConnectedTexture.Module.EAST_CONNECTED_PROPERTY) != false ? 16 : 0;
            rotationMatrix = (Matrix4f)rotationMatrices.get(sideConnectionFlags |= (Boolean)state.m_61143_((Property)IConnectedTexture.Module.WEST_CONNECTED_PROPERTY) != false ? 32 : 0);
            if (connectedSides <= 1 || sideConnectionFlags == 3 || sideConnectionFlags == 12 || sideConnectionFlags == 48) {
                mesh = this.CONDENSER ? condenserStraightMesh : evaporatorStraightMesh;
            } else {
                Mesh mesh2 = mesh = this.CONDENSER ? condenserCornerMesh : evaporatorCornerMesh;
            }
        }
        if (mesh == null) {
            return;
        }
        this.instance = batcher.createInstance((Vector3ic)position, mesh, null, rotationMatrix, null);
    }

    public void destroyModel() {
        if (this.instance != null) {
            this.instance.delete();
            this.instance = null;
        }
    }

    static {
        Quartz.EVENT_BUS.addListener(HeatExchangerChannelTile::onQuartzStartup);
        rotationMatrices = new ReferenceArrayList();
        rotationMatrices.clear();
        for (int i = 0; i < 64; ++i) {
            rotationMatrices.add((Object)new Matrix4f());
        }
        Vector3f preTranslate = new Vector3f(0.5f);
        Vector3f postTranslate = new Vector3f(-0.5f);
        ((Matrix4f)rotationMatrices.get(12)).translate((Vector3fc)preTranslate).rotate((float)Math.toRadians(90.0), 1.0f, 0.0f, 0.0f).translate((Vector3fc)postTranslate);
        ((Matrix4f)rotationMatrices.get(4)).set((Matrix4fc)rotationMatrices.get(12));
        ((Matrix4f)rotationMatrices.get(8)).set((Matrix4fc)rotationMatrices.get(12));
        ((Matrix4f)rotationMatrices.get(48)).translate((Vector3fc)preTranslate).rotate((float)Math.toRadians(90.0), 0.0f, 0.0f, 1.0f).translate((Vector3fc)postTranslate);
        ((Matrix4f)rotationMatrices.get(16)).set((Matrix4fc)rotationMatrices.get(48));
        ((Matrix4f)rotationMatrices.get(32)).set((Matrix4fc)rotationMatrices.get(48));
        ((Matrix4f)rotationMatrices.get(6)).identity();
        ((Matrix4f)rotationMatrices.get(34)).translate((Vector3fc)preTranslate).rotate((float)Math.toRadians(90.0), 0.0f, 1.0f, 0.0f).translate((Vector3fc)postTranslate);
        ((Matrix4f)rotationMatrices.get(10)).translate((Vector3fc)preTranslate).rotate((float)Math.toRadians(180.0), 0.0f, 1.0f, 0.0f).translate((Vector3fc)postTranslate);
        ((Matrix4f)rotationMatrices.get(18)).translate((Vector3fc)preTranslate).rotate((float)Math.toRadians(-90.0), 0.0f, 1.0f, 0.0f).translate((Vector3fc)postTranslate);
        ((Matrix4f)rotationMatrices.get(5)).translate((Vector3fc)preTranslate).rotate((float)Math.toRadians(90.0), 1.0f, 0.0f, 0.0f).translate((Vector3fc)postTranslate);
        ((Matrix4f)rotationMatrices.get(33)).translate((Vector3fc)preTranslate).rotate((float)Math.toRadians(180.0), 1.0f, 0.0f, 0.0f).rotate((float)Math.toRadians(90.0), 0.0f, 1.0f, 0.0f).translate((Vector3fc)postTranslate);
        ((Matrix4f)rotationMatrices.get(9)).translate((Vector3fc)preTranslate).rotate((float)Math.toRadians(180.0), 1.0f, 0.0f, 0.0f).translate((Vector3fc)postTranslate);
        ((Matrix4f)rotationMatrices.get(17)).translate((Vector3fc)preTranslate).rotate((float)Math.toRadians(180.0), 1.0f, 0.0f, 0.0f).rotate((float)Math.toRadians(-90.0), 0.0f, 1.0f, 0.0f).translate((Vector3fc)postTranslate);
        ((Matrix4f)rotationMatrices.get(40)).translate((Vector3fc)preTranslate).rotate((float)Math.toRadians(-90.0), 1.0f, 0.0f, 0.0f).rotate((float)Math.toRadians(90.0), 0.0f, 1.0f, 0.0f).translate((Vector3fc)postTranslate);
        ((Matrix4f)rotationMatrices.get(20)).translate((Vector3fc)preTranslate).rotate((float)Math.toRadians(90.0), 1.0f, 0.0f, 0.0f).rotate((float)Math.toRadians(-90.0), 0.0f, 1.0f, 0.0f).translate((Vector3fc)postTranslate);
        ((Matrix4f)rotationMatrices.get(24)).translate((Vector3fc)preTranslate).rotate((float)Math.toRadians(-90.0), 1.0f, 0.0f, 0.0f).rotate((float)Math.toRadians(-90.0), 0.0f, 1.0f, 0.0f).translate((Vector3fc)postTranslate);
        ((Matrix4f)rotationMatrices.get(36)).translate((Vector3fc)preTranslate).rotate((float)Math.toRadians(90.0), 1.0f, 0.0f, 0.0f).rotate((float)Math.toRadians(90.0), 0.0f, 1.0f, 0.0f).translate((Vector3fc)postTranslate);
    }
}

