/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.lib.data.MCDataByteBuf;
import codechicken.lib.data.MCDataInput;
import codechicken.multipart.api.TickableTile;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.init.CBMultipartModContent;
import codechicken.multipart.network.MultiPartSPH;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MultipartLoadHandler {
    private static final Logger logger = LogManager.getLogger();
    private static final CrashLock LOCK = new CrashLock("Already initialized.");

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, MultipartLoadHandler::onChunkLoad);
    }

    private static void onChunkLoad(ChunkEvent.Load event) {
        Object object;
        if (event.getLevel().m_5776_() && (object = event.getChunk()) instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)object;
            for (BlockEntity be : List.copyOf(chunk.m_62954_().values())) {
                if (!(be instanceof TileNBTContainer)) continue;
                TileNBTContainer tile = (TileNBTContainer)be;
                if (tile.updateTag == null) continue;
                byte[] data = tile.updateTag.m_128463_("data");
                TileMultipart.handleDescPacket(tile.m_58904_(), tile.m_58899_(), (MCDataInput)new MCDataByteBuf(Unpooled.wrappedBuffer((byte[])data)));
            }
        }
    }

    public static class TileNBTContainer
    extends BlockEntity
    implements TickableTile {
        private int ticks;
        private boolean failed;
        private boolean loaded;
        @Nullable
        public CompoundTag tag;
        @Nullable
        public CompoundTag updateTag;

        public TileNBTContainer(BlockPos pos, BlockState state) {
            super((BlockEntityType)CBMultipartModContent.MULTIPART_TILE_TYPE.get(), pos, state);
        }

        public void handleUpdateTag(CompoundTag tag) {
            if (!tag.m_128441_("data")) {
                logger.warn("Received update tag without 'data' field. Ignoring..");
                return;
            }
            this.updateTag = tag;
        }

        public void m_142466_(CompoundTag compound) {
            super.m_142466_(compound);
            this.tag = compound.m_6426_();
        }

        public void m_183515_(CompoundTag compound) {
            super.m_183515_(compound);
            if (this.tag != null) {
                compound.m_128391_(this.tag);
            }
        }

        @Override
        public void tick() {
            if (this.f_58857_ == null || this.f_58857_.f_46443_) {
                return;
            }
            if (!this.failed && !this.loaded) {
                if (this.tag != null) {
                    TileMultipart newTile = TileMultipart.fromNBT(this.tag, this.m_58899_());
                    if (newTile != null) {
                        newTile.m_6339_();
                        this.f_58857_.m_151523_((BlockEntity)newTile);
                        newTile.notifyTileChange();
                        newTile.notifyShapeChange();
                        MultiPartSPH.sendDescUpdate(newTile);
                    } else {
                        this.f_58857_.m_7471_(this.m_58899_(), false);
                    }
                    this.loaded = true;
                } else {
                    ++this.ticks;
                    if (this.ticks % 600 == 0) {
                        this.failed = true;
                        logger.warn("TileNBTContainer at '{}' still exists after {} ticks! Deleting..", (Object)this.m_58899_(), (Object)this.ticks);
                        this.f_58857_.m_7471_(this.m_58899_(), false);
                    }
                }
            }
        }
    }
}

