/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin;

import codechicken.mixin.MixinFactoryImpl;
import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.api.MixinFactory;
import codechicken.mixin.util.Utils;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SidedFactory<B, F, T>
extends MixinFactoryImpl<B, F> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidedFactory.class);
    protected final Map<Class<?>, MixinFactory.TraitKey> clientTraits = new HashMap();
    protected final Map<Class<?>, MixinFactory.TraitKey> serverTraits = new HashMap();
    protected final Map<Class<?>, ImmutableSet<MixinFactory.TraitKey>> clientObjectTraitCache = new HashMap();
    protected final Map<Class<?>, ImmutableSet<MixinFactory.TraitKey>> serverObjectTraitCache = new HashMap();

    protected SidedFactory(MixinCompiler mc, Class<B> baseType, Class<F> factory, String suffix) {
        super(mc, baseType, factory, suffix);
    }

    public void registerTrait(Class<?> marker, Class<?> trait) {
        this.registerTrait(marker, trait, trait);
    }

    public void registerTrait(Class<?> marker, @Nullable Class<?> clientTrait, @Nullable Class<?> serverTrait) {
        if (clientTrait != null) {
            this.register(this.clientTraits, marker, clientTrait);
        }
        if (serverTrait != null) {
            this.register(this.serverTraits, marker, serverTrait);
        }
    }

    public ImmutableSet<MixinFactory.TraitKey> getTraitsForObject(T thing, boolean client) {
        return this.getObjectTraitCache(client).computeIfAbsent(thing.getClass(), clazz -> {
            Map<Class<?>, MixinFactory.TraitKey> traits = this.getTraitMap(client);
            return this.hierarchy((Class<?>)clazz).map(traits::get).filter(Objects::nonNull).toImmutableSet();
        });
    }

    protected FastStream<Class<?>> hierarchy(Class<?> clazz) {
        return FastStream.concat((Iterable[])new Iterable[]{FastStream.of(clazz), FastStream.of((Object[])clazz.getInterfaces()).flatMap(this::hierarchy), FastStream.ofNullable(clazz.getSuperclass()).flatMap(this::hierarchy)});
    }

    protected Map<Class<?>, MixinFactory.TraitKey> getTraitMap(boolean client) {
        return client ? this.clientTraits : this.serverTraits;
    }

    protected Map<Class<?>, ImmutableSet<MixinFactory.TraitKey>> getObjectTraitCache(boolean client) {
        return client ? this.clientObjectTraitCache : this.serverObjectTraitCache;
    }

    protected void register(Map<Class<?>, MixinFactory.TraitKey> map, Class<?> marker, Class<?> trait) {
        String tName = Utils.asmName(trait);
        MixinFactory.TraitKey existing = map.get(marker);
        if (existing != null) {
            if (existing.tName().equals(tName)) {
                LOGGER.error("Attempted to re-register trait for '{}' with a different impl. Ignoring. Existing: '{}', New: '{}'", new Object[]{marker, existing.tName(), tName});
            } else {
                LOGGER.error("Skipping re-register of trait for '{}' and impl '{}'", marker, (Object)tName);
            }
            return;
        }
        map.put(marker, this.registerTrait(trait));
    }
}

